/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public abstract class DeclarationInTextSource
implements StatementSourceReference {
    private final String sourceName;

    DeclarationInTextSource(String sourceName) {
        this.sourceName = sourceName;
    }

    public static DeclarationInTextSource inSource(String sourceName) {
        return new InSource(sourceName);
    }

    public static DeclarationInTextSource atLine(String sourceName, int line) {
        return new AtLine(sourceName, line);
    }

    public static DeclarationInTextSource atPosition(String sourceName, int line, int position) {
        return new AtPosition(sourceName, line, position);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    @Override
    public abstract String toString();

    private static final class AtPosition
    extends AtLine {
        private final int character;

        AtPosition(String sourceName, int line, int character) {
            super(sourceName, line);
            this.character = character;
        }

        @Override
        public String toString() {
            return this.getSourceName() + ':' + this.getLine() + ':' + this.character;
        }
    }

    private static class AtLine
    extends InSource {
        private final int line;

        AtLine(String sourceName, int line) {
            super(sourceName);
            this.line = line;
        }

        @Override
        public String toString() {
            return this.getSourceName() + ':' + this.line;
        }

        int getLine() {
            return this.line;
        }
    }

    private static class InSource
    extends DeclarationInTextSource {
        InSource(String sourceName) {
            super(sourceName);
        }

        @Override
        public String toString() {
            return this.getSourceName();
        }
    }
}

