/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.netconf.callhome.mount.CallHomeAuthRunnable;
import org.opendaylight.netconf.callhome.mount.CallhomeStatusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallHomeAuthHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeAuthHandler.class);
    private static final int WAITING_QUEUE_CAPABILITY = 1024;
    private static final long INITIAL_DELAY = 20L;
    private static final long DELAY = 10L;
    private final LinkedBlockingQueue<PublicKey> waitingQueue = new LinkedBlockingQueue(1024);
    private final Set<PublicKey> serverKeySet;
    private final ScheduledThreadPoolExecutor executor = new CallHomeAuthScheduleExecutor();

    private CallHomeAuthHandler() {
        this.serverKeySet = new HashSet<PublicKey>(1024);
    }

    public static CallHomeAuthHandler getInstance() {
        return CallHomeAuthHandlerHolder.HANDLER;
    }

    void startExecutor(CallhomeStatusReporter statusReporter) {
        this.executor.scheduleAtFixedRate(new CallHomeAuthRunnable(statusReporter), 20L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCallHomeTask(PublicKey serverKey) {
        CallHomeAuthHandler callHomeAuthHandler = this;
        synchronized (callHomeAuthHandler) {
            if (this.serverKeySet.contains(serverKey)) {
                LOG.info("Already in CallHome auth waitingQueue.");
            } else if (this.waitingQueue.offer(serverKey)) {
                this.serverKeySet.add(serverKey);
                LOG.info("Add CallHome auth task in waitingQueue[{}].", (Object)this.serverKeySet.size());
            } else {
                LOG.info("CallHome auth waitingQueue[{}] full. Discard.", (Object)this.serverKeySet.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublicKey takeCallHomeTask() {
        CallHomeAuthHandler callHomeAuthHandler = this;
        synchronized (callHomeAuthHandler) {
            PublicKey serverKey = this.waitingQueue.poll();
            int waitingSize = this.serverKeySet.size();
            if (serverKey == null && waitingSize > 0) {
                LOG.warn("Clear CallHome auth waitingSet[{}].", (Object)waitingSize);
                this.serverKeySet.clear();
            }
            return serverKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallHomeTask(PublicKey serverKey) {
        CallHomeAuthHandler callHomeAuthHandler = this;
        synchronized (callHomeAuthHandler) {
            LOG.info("Remove CallHome auth task in waitingQueue[{}].", (Object)this.serverKeySet.size());
            this.serverKeySet.remove(serverKey);
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private static final class CallHomeAuthThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        CallHomeAuthThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = String.format("callhome-auth-pool-%d-thread-", POOL_NUMBER.getAndIncrement());
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static final class CallHomeAuthScheduleExecutor
    extends ScheduledThreadPoolExecutor {
        private static final int CORE_POOL_SIZE = 1;

        CallHomeAuthScheduleExecutor() {
            super(1, new CallHomeAuthThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
            this.setMaximumPoolSize(1);
        }

        @Override
        public void afterExecute(Runnable runnable, Throwable throwable) {
            if (throwable != null) {
                LOG.warn("Execute CallHome auth runnable failed!", throwable);
            }
        }
    }

    private static final class CallHomeAuthHandlerHolder {
        private static final CallHomeAuthHandler HANDLER = new CallHomeAuthHandler();

        private CallHomeAuthHandlerHolder() {
        }
    }
}

