/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.callhome.mount.CallHomeAuthHandler;
import org.opendaylight.netconf.callhome.mount.CallhomeStatusReporter;
import org.opendaylight.netconf.callhome.protocol.AuthorizedKeysDecoder;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorization;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorizationProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.NetconfCallhomeServer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.AllowedDevices;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.Global;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.Device;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallHomeAuthProviderImpl
implements CallHomeAuthorizationProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeAuthProviderImpl.class);
    private static final InstanceIdentifier<Global> GLOBAL_PATH = InstanceIdentifier.create(NetconfCallhomeServer.class).child(Global.class);
    private static final DataTreeIdentifier<Global> GLOBAL = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, GLOBAL_PATH);
    private static final InstanceIdentifier<Device> ALLOWED_DEVICES_PATH = InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class).child(Device.class);
    private static final DataTreeIdentifier<Device> ALLOWED_DEVICES = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, ALLOWED_DEVICES_PATH);
    private static final DataTreeIdentifier<Device> ALLOWED_OP_DEVICES = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, ALLOWED_DEVICES_PATH);
    private final GlobalConfig globalConfig = new GlobalConfig();
    private final DeviceConfig deviceConfig = new DeviceConfig();
    private final DeviceOp deviceOp = new DeviceOp();
    private final ListenerRegistration<GlobalConfig> configReg;
    private final ListenerRegistration<DeviceConfig> deviceReg;
    private final ListenerRegistration<DeviceOp> deviceOpReg;
    private final CallhomeStatusReporter statusReporter;

    CallHomeAuthProviderImpl(DataBroker broker, CallhomeStatusReporter statusReporter) {
        this.configReg = broker.registerDataTreeChangeListener(GLOBAL, (DataTreeChangeListener)this.globalConfig);
        this.deviceReg = broker.registerDataTreeChangeListener(ALLOWED_DEVICES, (DataTreeChangeListener)this.deviceConfig);
        this.deviceOpReg = broker.registerDataTreeChangeListener(ALLOWED_OP_DEVICES, (DataTreeChangeListener)this.deviceOp);
        this.statusReporter = statusReporter;
        CallHomeAuthHandler.getInstance().startExecutor(statusReporter);
    }

    @Nonnull
    public CallHomeAuthorization provideAuth(@Nonnull SocketAddress remoteAddress, @Nonnull PublicKey serverKey) {
        Credentials credentials;
        Credentials deviceCred;
        String sessionName;
        Device deviceSpecific = this.deviceConfig.get(serverKey);
        if (deviceSpecific != null) {
            sessionName = deviceSpecific.getUniqueId();
            deviceCred = deviceSpecific.getCredentials();
        } else if (this.globalConfig.allowedUnknownKeys()) {
            deviceCred = null;
            sessionName = this.statusReporter.asForceListedDevice(serverKey);
        } else {
            CallHomeAuthHandler.getInstance().addCallHomeTask(serverKey);
            return CallHomeAuthorization.rejected();
        }
        Credentials credentials2 = credentials = deviceCred != null ? deviceCred : this.globalConfig.getCredentials();
        if (credentials == null) {
            LOG.info("No credentials found for {}, rejecting.", (Object)remoteAddress);
            return CallHomeAuthorization.rejected();
        }
        CallHomeAuthorization.Builder authBuilder = CallHomeAuthorization.serverAccepted((String)sessionName, (String)credentials.getUsername());
        for (String password : credentials.getPasswords()) {
            authBuilder.addPassword(password);
        }
        return authBuilder.build();
    }

    @Override
    public void close() {
        this.configReg.close();
        this.deviceReg.close();
        this.deviceOpReg.close();
        CallHomeAuthHandler.getInstance().close();
    }

    private static class GlobalConfig
    implements DataTreeChangeListener<Global> {
        private volatile Global current = null;

        private GlobalConfig() {
        }

        public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Global>> mods) {
            if (!mods.isEmpty()) {
                this.current = (Global)((DataTreeModification)Iterables.getLast(mods)).getRootNode().getDataAfter();
            }
        }

        boolean allowedUnknownKeys() {
            Global local = this.current;
            return local != null && Boolean.TRUE.equals(local.isAcceptAllSshKeys());
        }

        Credentials getCredentials() {
            return this.current != null ? this.current.getCredentials() : null;
        }
    }

    private static class DeviceOp
    implements DataTreeChangeListener<Device> {
        private final ConcurrentMap<String, Device> byPublicKey = new ConcurrentHashMap<String, Device>();

        private DeviceOp() {
        }

        public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Device>> mods) {
            for (DataTreeModification<Device> dataTreeModification : mods) {
                DataObjectModification rootNode = dataTreeModification.getRootNode();
                this.process((DataObjectModification<Device>)rootNode);
            }
        }

        private void process(DataObjectModification<Device> deviceMod) {
            Device before = (Device)deviceMod.getDataBefore();
            Device after = (Device)deviceMod.getDataAfter();
            if (before == null) {
                this.putDevice(after);
            } else if (after == null) {
                this.removeDevice(before);
            } else {
                if (!Objects.equal((Object)before.getSshHostKey(), (Object)after.getSshHostKey())) {
                    this.removeDevice(before);
                }
                this.putDevice(after);
            }
        }

        private void putDevice(Device device) {
            String key = device.getSshHostKey();
            this.byPublicKey.put(key, device);
        }

        private void removeDevice(Device device) {
            String key = device.getSshHostKey();
            this.byPublicKey.remove(key);
        }

        Device get(PublicKey serverKey) {
            String skey = "";
            try {
                skey = AuthorizedKeysDecoder.encodePublicKey((PublicKey)serverKey);
                return (Device)this.byPublicKey.get(skey);
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.error("Unable to encode server key: {}", (Object)skey, (Object)e);
                return null;
            }
        }
    }

    private static class DeviceConfig
    implements DataTreeChangeListener<Device> {
        private final AuthorizedKeysDecoder keyDecoder = new AuthorizedKeysDecoder();
        private final ConcurrentMap<PublicKey, Device> byPublicKey = new ConcurrentHashMap<PublicKey, Device>();

        private DeviceConfig() {
        }

        public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Device>> mods) {
            for (DataTreeModification<Device> dataTreeModification : mods) {
                DataObjectModification rootNode = dataTreeModification.getRootNode();
                this.process((DataObjectModification<Device>)rootNode);
            }
        }

        private void process(DataObjectModification<Device> deviceMod) {
            Device before = (Device)deviceMod.getDataBefore();
            Device after = (Device)deviceMod.getDataAfter();
            if (before == null) {
                this.putDevice(after);
            } else if (after == null) {
                this.removeDevice(before);
            } else {
                if (!Objects.equal((Object)before.getSshHostKey(), (Object)after.getSshHostKey())) {
                    this.removeDevice(before);
                }
                this.putDevice(after);
            }
        }

        private void putDevice(Device device) {
            PublicKey key = this.publicKey(device);
            if (key == null) {
                return;
            }
            this.byPublicKey.put(key, device);
        }

        private void removeDevice(Device device) {
            PublicKey key = this.publicKey(device);
            if (key == null) {
                return;
            }
            this.byPublicKey.remove(key);
        }

        private PublicKey publicKey(Device device) {
            String hostKey = device.getSshHostKey();
            try {
                return this.keyDecoder.decodePublicKey(hostKey);
            }
            catch (GeneralSecurityException e) {
                LOG.error("Unable to decode SSH key for {}. Ignoring update for this device", (Object)device.getUniqueId(), (Object)e);
                return null;
            }
        }

        private Device get(PublicKey key) {
            return (Device)this.byPublicKey.get(key);
        }
    }
}

