/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.util.Arrays;
import org.opendaylight.netconf.callhome.mount.CallHomeAuthHandler;
import org.opendaylight.netconf.callhome.mount.CallHomeMountProperties;
import org.opendaylight.netconf.callhome.mount.CallhomeStatusReporter;
import org.opendaylight.netconf.callhome.protocol.AuthorizedKeysDecoder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.CredentialsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.Device;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallHomeAuthRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeAuthRunnable.class);
    private static final Credentials CREDENTIALS = new CredentialsBuilder().setUsername(CallHomeMountProperties.USER_DEFINED.getCallHomeUsr()).setPasswords(Arrays.asList(CallHomeMountProperties.USER_DEFINED.getCallHomePwds().split(","))).build();
    private final CallhomeStatusReporter statusReporter;

    public CallHomeAuthRunnable(CallhomeStatusReporter statusReporter) {
        this.statusReporter = statusReporter;
    }

    @Override
    public void run() {
        int authRate = CallHomeMountProperties.USER_DEFINED.getAuthRate();
        for (int i = 0; i < authRate; ++i) {
            String uniqueId;
            PublicKey serverKey = CallHomeAuthHandler.getInstance().takeCallHomeTask();
            if (serverKey == null) {
                LOG.debug("No more CallHome auth task to handle.");
                break;
            }
            String sshEncodedKey = this.genSshEncodedKey(serverKey);
            try {
                uniqueId = CallHomeMountProperties.USER_DEFINED.md5(sshEncodedKey);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Unsupported encoding algorithm: md5. {}", (Object)ex.getMessage());
                CallHomeAuthHandler.getInstance().removeCallHomeTask(serverKey);
                break;
            }
            Device device = new DeviceBuilder().setUniqueId(uniqueId).withKey(new DeviceKey(uniqueId)).setSshHostKey(sshEncodedKey).setCredentials(CREDENTIALS).build();
            this.statusReporter.enableDevice(device);
            CallHomeAuthHandler.getInstance().removeCallHomeTask(serverKey);
        }
    }

    private String genSshEncodedKey(PublicKey serverKey) {
        try {
            return AuthorizedKeysDecoder.encodePublicKey((PublicKey)serverKey);
        }
        catch (IOException e) {
            LOG.warn("Unable to encode public key to ssh format.", (Throwable)e);
            return serverKey.toString();
        }
    }
}

