/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.callhome.mount.CallHomeMountSessionContext;
import org.opendaylight.netconf.callhome.mount.CallHomeMountSessionManager;
import org.opendaylight.netconf.callhome.mount.CallHomeTopology;
import org.opendaylight.netconf.callhome.protocol.CallHomeChannelActivator;
import org.opendaylight.netconf.callhome.protocol.CallHomeNetconfSubsystemListener;
import org.opendaylight.netconf.callhome.protocol.CallHomeProtocolSessionContext;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.topology.api.SchemaRepositoryProvider;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallHomeMountDispatcher
implements NetconfClientDispatcher,
CallHomeNetconfSubsystemListener {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeMountDispatcher.class);
    private final String topologyId;
    private final EventExecutor eventExecutor;
    private final ScheduledThreadPool keepaliveExecutor;
    private final ThreadPool processingExecutor;
    private final SchemaRepositoryProvider schemaRepositoryProvider;
    private final CallHomeMountSessionManager sessionManager;
    private final DataBroker dataBroker;
    private final DOMMountPointService mountService;
    private final AAAEncryptionService encryptionService;
    protected CallHomeTopology topology;
    private final CallHomeMountSessionContext.CloseCallback onCloseHandler = deviceContext -> {
        LOG.info("Removing {} from Netconf Topology.", (Object)deviceContext.getId());
        this.topology.disconnectNode(deviceContext.getId());
    };
    private final DeviceActionFactory deviceActionFactory;

    public CallHomeMountDispatcher(String topologyId, EventExecutor eventExecutor, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, SchemaRepositoryProvider schemaRepositoryProvider, DataBroker dataBroker, DOMMountPointService mountService, AAAEncryptionService encryptionService) {
        this(topologyId, eventExecutor, keepaliveExecutor, processingExecutor, schemaRepositoryProvider, dataBroker, mountService, encryptionService, null);
    }

    public CallHomeMountDispatcher(String topologyId, EventExecutor eventExecutor, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, SchemaRepositoryProvider schemaRepositoryProvider, DataBroker dataBroker, DOMMountPointService mountService, AAAEncryptionService encryptionService, DeviceActionFactory deviceActionFactory) {
        this.topologyId = topologyId;
        this.eventExecutor = eventExecutor;
        this.keepaliveExecutor = keepaliveExecutor;
        this.processingExecutor = processingExecutor;
        this.schemaRepositoryProvider = schemaRepositoryProvider;
        this.deviceActionFactory = deviceActionFactory;
        this.sessionManager = new CallHomeMountSessionManager();
        this.dataBroker = dataBroker;
        this.mountService = mountService;
        this.encryptionService = encryptionService;
    }

    public Future<NetconfClientSession> createClient(NetconfClientConfiguration clientConfiguration) {
        return this.activateChannel(clientConfiguration);
    }

    public Future<Void> createReconnectingClient(NetconfReconnectingClientConfiguration clientConfiguration) {
        return this.activateChannel((NetconfClientConfiguration)clientConfiguration);
    }

    private <V> Future<V> activateChannel(NetconfClientConfiguration conf) {
        InetSocketAddress remoteAddr = conf.getAddress();
        CallHomeMountSessionContext context = this.getSessionManager().getByAddress(remoteAddr);
        LOG.info("Activating NETCONF channel for ip {} device context {}", (Object)remoteAddr, (Object)context);
        if (context == null) {
            return new FailedFuture(this.eventExecutor, (Throwable)new NullPointerException());
        }
        return context.activateNetconfChannel(conf.getSessionListener());
    }

    void createTopology() {
        this.topology = new CallHomeTopology(this.topologyId, this, this.eventExecutor, this.keepaliveExecutor, this.processingExecutor, this.schemaRepositoryProvider, this.dataBroker, this.mountService, this.encryptionService, this.deviceActionFactory);
    }

    public void onNetconfSubsystemOpened(CallHomeProtocolSessionContext session, CallHomeChannelActivator activator) {
        CallHomeMountSessionContext deviceContext = this.getSessionManager().createSession(session, activator, this.onCloseHandler);
        if (null != deviceContext) {
            NodeId nodeId = deviceContext.getId();
            Node configNode = deviceContext.getConfigNode();
            LOG.info("Provisioning fake config {}", (Object)configNode);
            this.topology.connectNode(nodeId, configNode);
        }
    }

    public CallHomeMountSessionManager getSessionManager() {
        return this.sessionManager;
    }
}

