/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public enum CallHomeMountProperties {
    USER_DEFINED;

    private static final String UTF_8 = "UTF-8";
    private final int authRate;
    private final Integer concurrentRpcLimit;
    private final Long keepalive;
    private final Long requestTimeout;
    private final Boolean schemaLess;
    private final Boolean subscribe;
    private final Boolean tcpOnly;
    private final String callHomeUsr;
    private final String callHomePwds;
    private final MessageDigest messageDigest;

    private CallHomeMountProperties() {
        String path = System.getProperty("user.dir") + File.separator + "etc" + File.separator + "netconf.properties";
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(path);){
            properties.load(inputStream);
            this.authRate = Integer.parseInt(properties.getProperty("callhome.authorization.rate"));
            this.schemaLess = Boolean.valueOf(properties.getProperty("callhome.netconf.node.schemaless"));
            this.subscribe = Boolean.valueOf(properties.getProperty("callhome.netconf.node.subscribe"));
            this.tcpOnly = Boolean.valueOf(properties.getProperty("callhome.netconf.node.tcpOnly"));
            this.concurrentRpcLimit = Integer.valueOf(properties.getProperty("callhome.netconf.node.concurrentRpcLimit"));
            this.keepalive = Long.valueOf(properties.getProperty("callhome.netconf.node.keepalive"));
            this.requestTimeout = Long.valueOf(properties.getProperty("callhome.netconf.node.defaultRequestTimeout"));
            this.callHomeUsr = properties.getProperty("callhome.credentials.username", "raisecom");
            this.callHomePwds = properties.getProperty("callhome.credentials.passwords", "raisecom");
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (IOException | NumberFormatException ex) {
            throw new IllegalArgumentException("Load/parse netconf.properties failed.", ex);
        }
        catch (NoSuchAlgorithmException noAlgorithmEx) {
            throw new UnsupportedOperationException("No such algorithm: md5.", noAlgorithmEx);
        }
    }

    public int getAuthRate() {
        return this.authRate;
    }

    public Boolean getSchemaLess() {
        return this.schemaLess;
    }

    public Boolean getSubscribe() {
        return this.subscribe;
    }

    public Boolean getTcpOnly() {
        return this.tcpOnly;
    }

    public Integer getConcurrentRpcLimit() {
        return this.concurrentRpcLimit;
    }

    public Long getKeepalive() {
        return this.keepalive;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getCallHomeUsr() {
        return this.callHomeUsr;
    }

    public String getCallHomePwds() {
        return this.callHomePwds;
    }

    public String md5(String plainText) throws UnsupportedEncodingException {
        return ByteUtils.toHexString((byte[])this.messageDigest.digest(plainText.getBytes(UTF_8)));
    }
}

