/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.opendaylight.netconf.callhome.mount.CallHomeMountSessionContext;
import org.opendaylight.netconf.callhome.protocol.CallHomeChannelActivator;
import org.opendaylight.netconf.callhome.protocol.CallHomeProtocolSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallHomeMountSessionManager
implements CallHomeMountSessionContext.CloseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeMountSessionManager.class);
    private final ConcurrentMap<SocketAddress, CallHomeMountSessionContext> contextByAddress = new ConcurrentHashMap<SocketAddress, CallHomeMountSessionContext>();
    private final ConcurrentMap<PublicKey, CallHomeMountSessionContext> contextByPublicKey = new ConcurrentHashMap<PublicKey, CallHomeMountSessionContext>();

    @Nullable
    CallHomeMountSessionContext getByAddress(InetSocketAddress remoteAddr) {
        return (CallHomeMountSessionContext)this.contextByAddress.get(remoteAddr);
    }

    CallHomeMountSessionContext createSession(CallHomeProtocolSessionContext session, CallHomeChannelActivator activator, CallHomeMountSessionContext.CloseCallback onCloseHandler) {
        String name = session.getSessionName();
        CallHomeMountSessionContext deviceContext = new CallHomeMountSessionContext(name, session, activator, devCtxt -> {
            this.onClosed(devCtxt);
            onCloseHandler.onClosed(devCtxt);
        });
        InetSocketAddress remoteAddress = session.getRemoteAddress();
        CallHomeMountSessionContext prev = this.contextByAddress.put(remoteAddress, deviceContext);
        if (prev != null) {
            LOG.warn("Remote {} replaced context {} with {}", new Object[]{remoteAddress, prev, deviceContext});
        }
        return deviceContext;
    }

    @Override
    public void onClosed(CallHomeMountSessionContext deviceContext) {
        CallHomeProtocolSessionContext session = deviceContext.getProtocol();
        this.contextByAddress.remove(session.getRemoteAddress(), deviceContext);
        this.contextByPublicKey.remove(session.getRemoteServerKey(), deviceContext);
    }
}

