/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private Properties properties;

    public Configuration() {
        this.properties = new Properties();
    }

    public Configuration(String path) throws ConfigurationException {
        try {
            this.properties = this.readFromPath(path);
        }
        catch (IOException ioe) {
            throw new ReadException(path, ioe);
        }
    }

    private Properties readFromPath(String filePath) throws IOException {
        return this.readFromFile(new File(filePath));
    }

    private Properties readFromFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.properties = Configuration.readFrom(stream);
        return this.properties;
    }

    private static Properties readFrom(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        return properties;
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    String get(String key) {
        String result = (String)this.properties.get(key);
        if (result == null) {
            throw new MissingException(key);
        }
        return result;
    }

    public int getAsPort(String key) {
        String keyValue = this.get(key);
        try {
            int newPort = Integer.parseInt(keyValue);
            if (newPort < 0 || newPort > 65535) {
                throw new IllegalValueException(key, keyValue);
            }
            return newPort;
        }
        catch (NumberFormatException e) {
            throw new IllegalValueException(key, keyValue, e);
        }
    }

    public static class IllegalValueException
    extends ConfigurationException {
        private static final long serialVersionUID = -1172346869408302687L;
        private final String key;
        private final String value;

        IllegalValueException(String key, String value) {
            super("Key has an illegal value. Key: " + key + ", Value: " + value);
            this.key = key;
            this.value = value;
        }

        IllegalValueException(String key, String value, Exception cause) {
            super("Key has an illegal value. Key: " + key + ", Value: " + value, cause);
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MissingException
    extends ConfigurationException {
        private static final long serialVersionUID = 3406998256398889038L;
        private final String key;

        MissingException(String key) {
            super("Key not found: " + key);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class ReadException
    extends ConfigurationException {
        private static final long serialVersionUID = 1661483843463184121L;

        ReadException(String msg, Exception exc) {
            super(msg, exc);
        }
    }

    public static abstract class ConfigurationException
    extends RuntimeException {
        private static final long serialVersionUID = -7759423506815697761L;

        ConfigurationException(String msg) {
            super(msg);
        }

        ConfigurationException(String msg, Exception cause) {
            super(msg, cause);
        }
    }
}

