/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.callhome.mount.CallHomeAuthProviderImpl;
import org.opendaylight.netconf.callhome.mount.CallHomeMountDispatcher;
import org.opendaylight.netconf.callhome.mount.CallhomeStatusReporter;
import org.opendaylight.netconf.callhome.mount.Configuration;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorizationProvider;
import org.opendaylight.netconf.callhome.protocol.CallHomeNetconfSubsystemListener;
import org.opendaylight.netconf.callhome.protocol.NetconfCallHomeServer;
import org.opendaylight.netconf.callhome.protocol.NetconfCallHomeServerBuilder;
import org.opendaylight.netconf.callhome.protocol.StatusRecorder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.Device1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.Device1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.NetconfCallhomeServer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.AllowedDevices;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.Device;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IetfZeroTouchCallHomeServerProvider
implements AutoCloseable,
DataTreeChangeListener<AllowedDevices> {
    private static final String APPNAME = "CallHomeServer";
    static final InstanceIdentifier<AllowedDevices> ALL_DEVICES = InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class);
    private static final Logger LOG = LoggerFactory.getLogger(IetfZeroTouchCallHomeServerProvider.class);
    private final DataBroker dataBroker;
    private final CallHomeMountDispatcher mountDispacher;
    private final CallHomeAuthProviderImpl authProvider;
    protected NetconfCallHomeServer server;
    private ListenerRegistration<IetfZeroTouchCallHomeServerProvider> listenerReg = null;
    private static final String CALL_HOME_PORT_KEY = "DefaultCallHomePort";
    private int port = 0;
    private final CallhomeStatusReporter statusReporter;

    public IetfZeroTouchCallHomeServerProvider(DataBroker dataBroker, CallHomeMountDispatcher mountDispacher) {
        this.dataBroker = dataBroker;
        this.mountDispacher = mountDispacher;
        this.statusReporter = new CallhomeStatusReporter(dataBroker);
        this.authProvider = new CallHomeAuthProviderImpl(dataBroker, this.statusReporter);
    }

    public void init() {
        try {
            LOG.info("Initializing provider for {}", (Object)APPNAME);
            this.initializeServer();
            this.listenerReg = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, ALL_DEVICES), (DataTreeChangeListener)this);
            LOG.info("Initialization complete for {}", (Object)APPNAME);
        }
        catch (IOException | Configuration.ConfigurationException e) {
            LOG.error("Unable to successfully initialize", (Throwable)e);
        }
    }

    public void setPort(String portStr) {
        try {
            Configuration configuration = new Configuration();
            configuration.set(CALL_HOME_PORT_KEY, portStr);
            this.port = configuration.getAsPort(CALL_HOME_PORT_KEY);
            LOG.info("Setting port for call home server to {}", (Object)portStr);
        }
        catch (Configuration.ConfigurationException e) {
            LOG.error("Problem trying to set port for call home server {}", (Object)portStr, (Object)e);
        }
    }

    private CallHomeAuthorizationProvider getCallHomeAuthorization() {
        return this.authProvider;
    }

    private void initializeServer() throws IOException {
        LOG.info("Initializing Call Home server instance");
        CallHomeAuthorizationProvider provider = this.getCallHomeAuthorization();
        NetconfCallHomeServerBuilder builder = new NetconfCallHomeServerBuilder(provider, (CallHomeNetconfSubsystemListener)this.mountDispacher, (StatusRecorder)this.statusReporter);
        if (this.port > 0) {
            builder.setBindAddress(new InetSocketAddress(this.port));
        }
        builder.setNettyGroup((EventLoopGroup)new NioEventLoopGroup(1));
        this.server = builder.build();
        this.server.bind();
        this.mountDispacher.createTopology();
        LOG.info("Initialization complete for Call Home server instance");
    }

    @VisibleForTesting
    void assertValid(Object obj, String description) {
        if (obj == null) {
            throw new RuntimeException(String.format("Failed to find %s in IetfZeroTouchCallHomeProvider.initialize()", description));
        }
    }

    @Override
    public void close() {
        this.authProvider.close();
        this.statusReporter.close();
        if (this.listenerReg != null) {
            this.listenerReg.close();
        }
        if (this.server != null) {
            this.server.close();
        }
        LOG.info("Successfully closed provider for {}", (Object)APPNAME);
    }

    public void onDataTreeChanged(Collection<DataTreeModification<AllowedDevices>> changes) {
        HashSet deletedDevices = new HashSet();
        HashSet cfgDevices = new HashSet();
        for (DataTreeModification<AllowedDevices> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            switch (rootNode.getModificationType()) {
                case DELETE: {
                    deletedDevices.add(change.getRootPath().getRootIdentifier());
                    break;
                }
                case WRITE: 
                case SUBTREE_MODIFIED: {
                    cfgDevices.addAll(((AllowedDevices)rootNode.getDataAfter()).getDevice());
                    break;
                }
            }
        }
        this.handleDeletedDevices(deletedDevices);
        try {
            for (Device confDevice : cfgDevices) {
                this.readAndUpdateStatus(confDevice);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Error trying to read the whitelist devices", (Throwable)e);
        }
    }

    private void handleDeletedDevices(Set<InstanceIdentifier<?>> deletedDevices) {
        if (deletedDevices.isEmpty()) {
            return;
        }
        WriteTransaction opTx = this.dataBroker.newWriteOnlyTransaction();
        for (InstanceIdentifier<?> removedIID : deletedDevices) {
            LOG.info("Deleting the entry for callhome device {}", removedIID);
            opTx.delete(LogicalDatastoreType.OPERATIONAL, removedIID);
        }
        opTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Device deletions committed");
            }

            public void onFailure(Throwable cause) {
                LOG.warn("Failed to commit device deletions", cause);
            }
        }, MoreExecutors.directExecutor());
    }

    private void readAndUpdateStatus(final Device cfgDevice) throws InterruptedException, ExecutionException {
        KeyedInstanceIdentifier deviceIID = InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class).child(Device.class, (Identifier)new DeviceKey(cfgDevice.getUniqueId()));
        ReadWriteTransaction tx = this.dataBroker.newReadWriteTransaction();
        FluentFuture deviceFuture = tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)deviceIID);
        Optional opDevGet = (Optional)deviceFuture.get();
        Device1 devStatus = opDevGet.isPresent() ? (Device1)((Device)opDevGet.get()).augmentation(Device1.class) : new Device1Builder().setDeviceStatus(Device1.DeviceStatus.DISCONNECTED).build();
        tx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)deviceIID, (DataObject)new DeviceBuilder().addAugmentation(Device1.class, (Augmentation)devStatus).setSshHostKey(cfgDevice.getSshHostKey()).setUniqueId(cfgDevice.getUniqueId()).build());
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Device {} status update committed", (Object)cfgDevice.key());
            }

            public void onFailure(Throwable cause) {
                LOG.warn("Failed to commit device {} status update", (Object)cfgDevice.key(), (Object)cause);
            }
        }, MoreExecutors.directExecutor());
    }
}

