/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class PKIUtil {
    private static final Provider BCPROV;
    private static final String KEY_FACTORY_TYPE_RSA = "RSA";
    private static final String KEY_FACTORY_TYPE_DSA = "DSA";
    private static final String KEY_FACTORY_TYPE_ECDSA = "EC";
    private static final KeyFactorySupplier RSA_KEY_FACTORY_SUPPLIER;
    private static final KeyFactorySupplier DSA_KEY_FACTORY_SUPPLIER;
    private static final KeyFactorySupplier ECDSA_KEY_FACTORY_SUPPLIER;
    private static final Map<String, String> ECDSA_CURVES;
    private static final String ECDSA_SUPPORTED_CURVE_NAME = "nistp256";
    private static final String ECDSA_SUPPORTED_CURVE_NAME_SPEC;
    private static final int ECDSA_THIRD_STR_LEN = 65;
    private static final int ECDSA_TOTAL_STR_LEN = 104;
    private static final String KEY_TYPE_RSA = "ssh-rsa";
    private static final String KEY_TYPE_DSA = "ssh-dss";
    private static final String KEY_TYPE_ECDSA = "ecdsa-sha2-nistp256";
    private byte[] bytes = new byte[0];
    private int pos = 0;

    private static KeyFactorySupplier resolveKeyFactory(String algorithm) {
        KeyFactory factory;
        try {
            factory = KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return () -> {
                throw e;
            };
        }
        return () -> factory;
    }

    public PublicKey decodePublicKey(String keyLine) throws GeneralSecurityException {
        this.bytes = Base64.getDecoder().decode(keyLine.getBytes(StandardCharsets.UTF_8));
        if (this.bytes.length == 0) {
            throw new IllegalArgumentException("No Base64 part to decode in " + keyLine);
        }
        this.pos = 0;
        String type = this.decodeType();
        if (type.equals(KEY_TYPE_RSA)) {
            return this.decodeAsRSA();
        }
        if (type.equals(KEY_TYPE_DSA)) {
            return this.decodeAsDSA();
        }
        if (type.equals(KEY_TYPE_ECDSA)) {
            return this.decodeAsECDSA();
        }
        throw new IllegalArgumentException("Unknown decode key type " + type + " in " + keyLine);
    }

    private PublicKey decodeAsECDSA() throws GeneralSecurityException {
        KeyFactory ecdsaFactory = ECDSA_KEY_FACTORY_SUPPLIER.get();
        ECNamedCurveParameterSpec spec256r1 = ECNamedCurveTable.getParameterSpec((String)ECDSA_SUPPORTED_CURVE_NAME_SPEC);
        ECNamedCurveSpec params256r1 = new ECNamedCurveSpec(ECDSA_SUPPORTED_CURVE_NAME_SPEC, spec256r1.getCurve(), spec256r1.getG(), spec256r1.getN());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)params256r1.getCurve(), (byte[])Arrays.copyOfRange(this.bytes, 39, 104));
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)params256r1);
        return ecdsaFactory.generatePublic(pubKeySpec);
    }

    private PublicKey decodeAsDSA() throws GeneralSecurityException {
        KeyFactory dsaFactory = DSA_KEY_FACTORY_SUPPLIER.get();
        BigInteger var1 = this.decodeBigInt();
        BigInteger var2 = this.decodeBigInt();
        BigInteger var3 = this.decodeBigInt();
        BigInteger var4 = this.decodeBigInt();
        DSAPublicKeySpec spec = new DSAPublicKeySpec(var4, var1, var2, var3);
        return dsaFactory.generatePublic(spec);
    }

    private PublicKey decodeAsRSA() throws GeneralSecurityException {
        KeyFactory rsaFactory = RSA_KEY_FACTORY_SUPPLIER.get();
        BigInteger exponent = this.decodeBigInt();
        BigInteger modulus = this.decodeBigInt();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        return rsaFactory.generatePublic(spec);
    }

    private String decodeType() {
        int len = this.decodeInt();
        String type = new String(this.bytes, this.pos, len, StandardCharsets.UTF_8);
        this.pos += len;
        return type;
    }

    private int decodeInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    private BigInteger decodeBigInt() {
        int len = this.decodeInt();
        byte[] bigIntBytes = new byte[len];
        System.arraycopy(this.bytes, this.pos, bigIntBytes, 0, len);
        this.pos += len;
        return new BigInteger(bigIntBytes);
    }

    public String encodePublicKey(PublicKey publicKey) throws IOException {
        ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
        if (publicKey instanceof RSAPublicKey && publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_RSA)) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            DataOutputStream dataOutputStream = new DataOutputStream(byteOs);
            dataOutputStream.writeInt(KEY_TYPE_RSA.getBytes(StandardCharsets.UTF_8).length);
            dataOutputStream.write(KEY_TYPE_RSA.getBytes(StandardCharsets.UTF_8));
            dataOutputStream.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
            dataOutputStream.write(rsaPublicKey.getPublicExponent().toByteArray());
            dataOutputStream.writeInt(rsaPublicKey.getModulus().toByteArray().length);
            dataOutputStream.write(rsaPublicKey.getModulus().toByteArray());
        } else if (publicKey instanceof DSAPublicKey && publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_DSA)) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            DSAParams dsaParams = dsaPublicKey.getParams();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOs);
            dataOutputStream.writeInt(KEY_TYPE_DSA.getBytes(StandardCharsets.UTF_8).length);
            dataOutputStream.write(KEY_TYPE_DSA.getBytes(StandardCharsets.UTF_8));
            dataOutputStream.writeInt(dsaParams.getP().toByteArray().length);
            dataOutputStream.write(dsaParams.getP().toByteArray());
            dataOutputStream.writeInt(dsaParams.getQ().toByteArray().length);
            dataOutputStream.write(dsaParams.getQ().toByteArray());
            dataOutputStream.writeInt(dsaParams.getG().toByteArray().length);
            dataOutputStream.write(dsaParams.getG().toByteArray());
            dataOutputStream.writeInt(dsaPublicKey.getY().toByteArray().length);
            dataOutputStream.write(dsaPublicKey.getY().toByteArray());
        } else if (publicKey instanceof BCECPublicKey && publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_ECDSA)) {
            BCECPublicKey ecPublicKey = (BCECPublicKey)publicKey;
            DataOutputStream dataOutputStream = new DataOutputStream(byteOs);
            dataOutputStream.writeInt(KEY_TYPE_ECDSA.getBytes(StandardCharsets.UTF_8).length);
            dataOutputStream.write(KEY_TYPE_ECDSA.getBytes(StandardCharsets.UTF_8));
            dataOutputStream.writeInt(ECDSA_SUPPORTED_CURVE_NAME.getBytes(StandardCharsets.UTF_8).length);
            dataOutputStream.write(ECDSA_SUPPORTED_CURVE_NAME.getBytes(StandardCharsets.UTF_8));
            byte[] affineXCoord = ecPublicKey.getQ().getAffineXCoord().getEncoded();
            byte[] affineYCoord = ecPublicKey.getQ().getAffineYCoord().getEncoded();
            dataOutputStream.writeInt(affineXCoord.length + affineYCoord.length + 1);
            dataOutputStream.writeByte(4);
            dataOutputStream.write(affineXCoord);
            dataOutputStream.write(affineYCoord);
        } else {
            throw new IllegalArgumentException("Unknown public key encoding: " + publicKey.getAlgorithm());
        }
        return Base64.getEncoder().encodeToString(byteOs.toByteArray());
    }

    public KeyPair decodePrivateKey(StringReader reader, String passphrase) throws IOException {
        return PKIUtil.doDecodePrivateKey(reader, passphrase);
    }

    public KeyPair decodePrivateKey(String keyPath, String passphrase) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(keyPath), StandardCharsets.UTF_8);){
            KeyPair keyPair = PKIUtil.doDecodePrivateKey(reader, passphrase);
            return keyPair;
        }
    }

    private static KeyPair doDecodePrivateKey(Reader reader, String passphrase) throws IOException {
        try (PEMParser keyReader = new PEMParser(reader);){
            KeyPair keyPair;
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PEMDecryptorProvider decryptionProv = new JcePEMDecryptorProviderBuilder().setProvider(BCPROV).build(passphrase.toCharArray());
            Object privateKey = keyReader.readObject();
            if (privateKey instanceof PEMEncryptedKeyPair) {
                PEMKeyPair decryptedKeyPair = ((PEMEncryptedKeyPair)privateKey).decryptKeyPair(decryptionProv);
                keyPair = converter.getKeyPair(decryptedKeyPair);
            } else {
                keyPair = converter.getKeyPair((PEMKeyPair)privateKey);
            }
            KeyPair keyPair2 = keyPair;
            return keyPair2;
        }
    }

    static {
        Provider prov = Security.getProvider("BC");
        BCPROV = prov != null ? prov : new BouncyCastleProvider();
        RSA_KEY_FACTORY_SUPPLIER = PKIUtil.resolveKeyFactory(KEY_FACTORY_TYPE_RSA);
        DSA_KEY_FACTORY_SUPPLIER = PKIUtil.resolveKeyFactory(KEY_FACTORY_TYPE_DSA);
        ECDSA_KEY_FACTORY_SUPPLIER = PKIUtil.resolveKeyFactory(KEY_FACTORY_TYPE_ECDSA);
        ECDSA_CURVES = new HashMap<String, String>();
        ECDSA_CURVES.put(ECDSA_SUPPORTED_CURVE_NAME, "secp256r1");
        ECDSA_CURVES.put("nistp384", "secp384r1");
        ECDSA_CURVES.put("nistp512", "secp512r1");
        ECDSA_SUPPORTED_CURVE_NAME_SPEC = ECDSA_CURVES.get(ECDSA_SUPPORTED_CURVE_NAME);
    }

    @FunctionalInterface
    private static interface KeyFactorySupplier {
        public KeyFactory get() throws NoSuchAlgorithmException;
    }
}

