/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DatastoreConfigBuilder
implements Builder<DatastoreConfig> {
    private DatastoreConfig.Store _store;
    private BigInteger _timeToLive;
    private BigInteger _timeToWait;
    Map<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTIMETOLIVERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTIMETOWAITRANGE_RANGES;

    public DatastoreConfigBuilder() {
    }

    public DatastoreConfigBuilder(DatastoreConfig base) {
        Map aug;
        this._store = base.getStore();
        this._timeToLive = base.getTimeToLive();
        this._timeToWait = base.getTimeToWait();
        if (base instanceof DatastoreConfigImpl) {
            DatastoreConfigImpl impl = (DatastoreConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>>(aug);
        }
    }

    public DatastoreConfig.Store getStore() {
        return this._store;
    }

    public BigInteger getTimeToLive() {
        return this._timeToLive;
    }

    public BigInteger getTimeToWait() {
        return this._timeToWait;
    }

    public <E$$ extends Augmentation<DatastoreConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DatastoreConfigBuilder setStore(DatastoreConfig.Store value) {
        this._store = value;
        return this;
    }

    private static void checkTimeToLiveRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTIMETOLIVERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKTIMETOLIVERANGE_RANGES, (Object)value);
    }

    public DatastoreConfigBuilder setTimeToLive(BigInteger value) {
        if (value != null) {
            DatastoreConfigBuilder.checkTimeToLiveRange(value);
        }
        this._timeToLive = value;
        return this;
    }

    private static void checkTimeToWaitRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTIMETOWAITRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKTIMETOWAITRANGE_RANGES, (Object)value);
    }

    public DatastoreConfigBuilder setTimeToWait(BigInteger value) {
        if (value != null) {
            DatastoreConfigBuilder.checkTimeToWaitRange(value);
        }
        this._timeToWait = value;
        return this;
    }

    public DatastoreConfigBuilder addAugmentation(Class<? extends Augmentation<DatastoreConfig>> augmentationType, Augmentation<DatastoreConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DatastoreConfigBuilder removeAugmentation(Class<? extends Augmentation<DatastoreConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DatastoreConfig build() {
        return new DatastoreConfigImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTIMETOLIVERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTIMETOWAITRANGE_RANGES = a;
    }

    private static final class DatastoreConfigImpl
    implements DatastoreConfig {
        private final DatastoreConfig.Store _store;
        private final BigInteger _timeToLive;
        private final BigInteger _timeToWait;
        private Map<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DatastoreConfigImpl(DatastoreConfigBuilder base) {
            this._store = base.getStore();
            this._timeToLive = base.getTimeToLive();
            this._timeToWait = base.getTimeToWait();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<DatastoreConfig> getImplementedInterface() {
            return DatastoreConfig.class;
        }

        @Override
        public DatastoreConfig.Store getStore() {
            return this._store;
        }

        @Override
        public BigInteger getTimeToLive() {
            return this._timeToLive;
        }

        @Override
        public BigInteger getTimeToWait() {
            return this._timeToWait;
        }

        public <E$$ extends Augmentation<DatastoreConfig>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._store);
            result = 31 * result + Objects.hashCode(this._timeToLive);
            result = 31 * result + Objects.hashCode(this._timeToWait);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DatastoreConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DatastoreConfig other = (DatastoreConfig)obj;
            if (!Objects.equals((Object)this._store, (Object)other.getStore())) {
                return false;
            }
            if (!Objects.equals(this._timeToLive, other.getTimeToLive())) {
                return false;
            }
            if (!Objects.equals(this._timeToWait, other.getTimeToWait())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DatastoreConfigImpl otherImpl = (DatastoreConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DatastoreConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_store", (Object)((Object)this._store));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timeToLive", (Object)this._timeToLive);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timeToWait", (Object)this._timeToWait);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

