/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Authentication;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Domains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Grants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Roles;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Users;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AuthenticationBuilder
implements Builder<Authentication> {
    private Domains _domains;
    private Grants _grants;
    private Roles _roles;
    private Users _users;
    Map<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>> augmentation = Collections.emptyMap();

    public AuthenticationBuilder() {
    }

    public AuthenticationBuilder(Authentication base) {
        Map aug;
        this._domains = base.getDomains();
        this._grants = base.getGrants();
        this._roles = base.getRoles();
        this._users = base.getUsers();
        if (base instanceof AuthenticationImpl) {
            AuthenticationImpl impl = (AuthenticationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>>(aug);
        }
    }

    public Domains getDomains() {
        return this._domains;
    }

    public Grants getGrants() {
        return this._grants;
    }

    public Roles getRoles() {
        return this._roles;
    }

    public Users getUsers() {
        return this._users;
    }

    public <E$$ extends Augmentation<Authentication>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AuthenticationBuilder setDomains(Domains value) {
        this._domains = value;
        return this;
    }

    public AuthenticationBuilder setGrants(Grants value) {
        this._grants = value;
        return this;
    }

    public AuthenticationBuilder setRoles(Roles value) {
        this._roles = value;
        return this;
    }

    public AuthenticationBuilder setUsers(Users value) {
        this._users = value;
        return this;
    }

    public AuthenticationBuilder addAugmentation(Class<? extends Augmentation<Authentication>> augmentationType, Augmentation<Authentication> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AuthenticationBuilder removeAugmentation(Class<? extends Augmentation<Authentication>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Authentication build() {
        return new AuthenticationImpl(this);
    }

    private static final class AuthenticationImpl
    implements Authentication {
        private final Domains _domains;
        private final Grants _grants;
        private final Roles _roles;
        private final Users _users;
        private Map<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AuthenticationImpl(AuthenticationBuilder base) {
            this._domains = base.getDomains();
            this._grants = base.getGrants();
            this._roles = base.getRoles();
            this._users = base.getUsers();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Authentication> getImplementedInterface() {
            return Authentication.class;
        }

        @Override
        public Domains getDomains() {
            return this._domains;
        }

        @Override
        public Grants getGrants() {
            return this._grants;
        }

        @Override
        public Roles getRoles() {
            return this._roles;
        }

        @Override
        public Users getUsers() {
            return this._users;
        }

        public <E$$ extends Augmentation<Authentication>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._domains);
            result = 31 * result + Objects.hashCode(this._grants);
            result = 31 * result + Objects.hashCode(this._roles);
            result = 31 * result + Objects.hashCode(this._users);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Authentication.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Authentication other = (Authentication)obj;
            if (!Objects.equals(this._domains, other.getDomains())) {
                return false;
            }
            if (!Objects.equals(this._grants, other.getGrants())) {
                return false;
            }
            if (!Objects.equals(this._roles, other.getRoles())) {
                return false;
            }
            if (!Objects.equals(this._users, other.getUsers())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AuthenticationImpl otherImpl = (AuthenticationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Authentication");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_domains", (Object)this._domains);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_grants", (Object)this._grants);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_roles", (Object)this._roles);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_users", (Object)this._users);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

