/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.domains;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Domain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.domains.Domains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.domains.DomainsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomainsBuilder
implements Builder<Domains> {
    private String _description;
    private String _domainid;
    private String _name;
    private DomainsKey key;
    Map<Class<? extends Augmentation<Domains>>, Augmentation<Domains>> augmentation = Collections.emptyMap();

    public DomainsBuilder() {
    }

    public DomainsBuilder(Domain arg) {
        this._domainid = arg.getDomainid();
        this._name = arg.getName();
        this._description = arg.getDescription();
    }

    public DomainsBuilder(Domains base) {
        Map aug;
        this.key = base.key();
        this._domainid = base.getDomainid();
        this._description = base.getDescription();
        this._name = base.getName();
        if (base instanceof DomainsImpl) {
            DomainsImpl impl = (DomainsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Domains>>, Augmentation<Domains>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Domains>>, Augmentation<Domains>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Domain) {
            this._domainid = ((Domain)arg).getDomainid();
            this._name = ((Domain)arg).getName();
            this._description = ((Domain)arg).getDescription();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Domain]");
    }

    public DomainsKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDomainid() {
        return this._domainid;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<Domains>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DomainsBuilder withKey(DomainsKey key) {
        this.key = key;
        return this;
    }

    public DomainsBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public DomainsBuilder setDomainid(String value) {
        this._domainid = value;
        return this;
    }

    public DomainsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public DomainsBuilder addAugmentation(Class<? extends Augmentation<Domains>> augmentationType, Augmentation<Domains> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Domains>>, Augmentation<Domains>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DomainsBuilder removeAugmentation(Class<? extends Augmentation<Domains>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Domains build() {
        return new DomainsImpl(this);
    }

    private static final class DomainsImpl
    implements Domains {
        private final String _description;
        private final String _domainid;
        private final String _name;
        private final DomainsKey key;
        private Map<Class<? extends Augmentation<Domains>>, Augmentation<Domains>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DomainsImpl(DomainsBuilder base) {
            this.key = base.key() != null ? base.key() : new DomainsKey(base.getDomainid());
            this._domainid = this.key.getDomainid();
            this._description = base.getDescription();
            this._name = base.getName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Domains> getImplementedInterface() {
            return Domains.class;
        }

        @Override
        public DomainsKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getDomainid() {
            return this._domainid;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E$$ extends Augmentation<Domains>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._domainid);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Domains.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Domains other = (Domains)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._domainid, other.getDomainid())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomainsImpl otherImpl = (DomainsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Domains>>, Augmentation<Domains>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Domains");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_domainid", (Object)this._domainid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

