/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpPermission;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.PoliciesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PoliciesBuilder
implements Builder<Policies> {
    private String _description;
    private List<Permissions> _permissions;
    private String _resource;
    private PoliciesKey key;
    Map<Class<? extends Augmentation<Policies>>, Augmentation<Policies>> augmentation = Collections.emptyMap();

    public PoliciesBuilder() {
    }

    public PoliciesBuilder(HttpPermission arg) {
        this._resource = arg.getResource();
        this._permissions = arg.getPermissions();
        this._description = arg.getDescription();
    }

    public PoliciesBuilder(Policies base) {
        Map aug;
        this.key = base.key();
        this._resource = base.getResource();
        this._description = base.getDescription();
        this._permissions = base.getPermissions();
        if (base instanceof PoliciesImpl) {
            PoliciesImpl impl = (PoliciesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Policies>>, Augmentation<Policies>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Policies>>, Augmentation<Policies>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof HttpPermission) {
            this._resource = ((HttpPermission)arg).getResource();
            this._permissions = ((HttpPermission)arg).getPermissions();
            this._description = ((HttpPermission)arg).getDescription();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpPermission]");
    }

    public PoliciesKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public List<Permissions> getPermissions() {
        return this._permissions;
    }

    public String getResource() {
        return this._resource;
    }

    public <E$$ extends Augmentation<Policies>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PoliciesBuilder withKey(PoliciesKey key) {
        this.key = key;
        return this;
    }

    public PoliciesBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public PoliciesBuilder setPermissions(List<Permissions> values) {
        this._permissions = values;
        return this;
    }

    public PoliciesBuilder setResource(String value) {
        this._resource = value;
        return this;
    }

    public PoliciesBuilder addAugmentation(Class<? extends Augmentation<Policies>> augmentationType, Augmentation<Policies> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Policies>>, Augmentation<Policies>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PoliciesBuilder removeAugmentation(Class<? extends Augmentation<Policies>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Policies build() {
        return new PoliciesImpl(this);
    }

    private static final class PoliciesImpl
    implements Policies {
        private final String _description;
        private final List<Permissions> _permissions;
        private final String _resource;
        private final PoliciesKey key;
        private Map<Class<? extends Augmentation<Policies>>, Augmentation<Policies>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PoliciesImpl(PoliciesBuilder base) {
            this.key = base.key() != null ? base.key() : new PoliciesKey(base.getResource());
            this._resource = this.key.getResource();
            this._description = base.getDescription();
            this._permissions = base.getPermissions();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Policies> getImplementedInterface() {
            return Policies.class;
        }

        @Override
        public PoliciesKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public List<Permissions> getPermissions() {
            return this._permissions;
        }

        @Override
        public String getResource() {
            return this._resource;
        }

        public <E$$ extends Augmentation<Policies>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._permissions);
            result = 31 * result + Objects.hashCode(this._resource);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Policies.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Policies other = (Policies)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._permissions, other.getPermissions())) {
                return false;
            }
            if (!Objects.equals(this._resource, other.getResource())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PoliciesImpl otherImpl = (PoliciesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Policies>>, Augmentation<Policies>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Policies");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_permissions", this._permissions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_resource", (Object)this._resource);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

