/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.dispatch.OnComplete;
import akka.pattern.AskTimeoutException;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.api.NetconfTopologySingletonService;
import org.opendaylight.netconf.topology.singleton.impl.actors.NetconfNodeActor;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologySetup;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologyUtils;
import org.opendaylight.netconf.topology.singleton.messages.AskForMasterMountPoint;
import org.opendaylight.netconf.topology.singleton.messages.RefreshSlaveActor;
import org.opendaylight.netconf.topology.singleton.messages.UnregisterSlaveMountPoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

class NetconfNodeManager
implements ClusteredDataTreeChangeListener<Node>,
NetconfTopologySingletonService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNodeManager.class);
    private final Timeout actorResponseWaitTime;
    private final DOMMountPointService mountPointService;
    private final SchemaSourceRegistry schemaRegistry;
    private final SchemaRepository schemaRepository;
    private volatile NetconfTopologySetup setup;
    private volatile ListenerRegistration<NetconfNodeManager> dataChangeListenerRegistration;
    private volatile RemoteDeviceId id;
    @GuardedBy(value="this")
    private ActorRef slaveActorRef;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private int lastUpdateCount;

    NetconfNodeManager(NetconfTopologySetup setup, RemoteDeviceId id, Timeout actorResponseWaitTime, DOMMountPointService mountPointService) {
        this.setup = setup;
        this.id = id;
        this.schemaRegistry = setup.getSchemaResourcesDTO().getSchemaRegistry();
        this.schemaRepository = setup.getSchemaResourcesDTO().getSchemaRepository();
        this.actorResponseWaitTime = actorResponseWaitTime;
        this.mountPointService = mountPointService;
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Node>> changes) {
        block5: for (DataTreeModification<Node> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            NodeId nodeId = NetconfTopologyUtils.getNodeId(rootNode.getIdentifier());
            switch (rootNode.getModificationType()) {
                case SUBTREE_MODIFIED: {
                    LOG.debug("{}: Operational state for node {} - subtree modified from {} to {}", new Object[]{this.id, nodeId, rootNode.getDataBefore(), rootNode.getDataAfter()});
                    this.handleSlaveMountPoint((DataObjectModification<Node>)rootNode);
                    continue block5;
                }
                case WRITE: {
                    if (rootNode.getDataBefore() != null) {
                        LOG.debug("{}: Operational state for node {} updated from {} to {}", new Object[]{this.id, nodeId, rootNode.getDataBefore(), rootNode.getDataAfter()});
                    } else {
                        LOG.debug("{}: Operational state for node {} created: {}", new Object[]{this.id, nodeId, rootNode.getDataAfter()});
                    }
                    this.handleSlaveMountPoint((DataObjectModification<Node>)rootNode);
                    continue block5;
                }
                case DELETE: {
                    LOG.debug("{}: Operational state for node {} deleted.", (Object)this.id, (Object)nodeId);
                    this.unregisterSlaveMountpoint();
                    continue block5;
                }
            }
            LOG.debug("{}: Uknown operation for node: {}", (Object)this.id, (Object)nodeId);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeActor();
        if (this.dataChangeListenerRegistration != null) {
            this.dataChangeListenerRegistration.close();
            this.dataChangeListenerRegistration = null;
        }
    }

    @GuardedBy(value="this")
    private void closeActor() {
        if (this.slaveActorRef != null) {
            LOG.debug("{}: Sending poison pill to {}", (Object)this.id, (Object)this.slaveActorRef);
            this.slaveActorRef.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            this.slaveActorRef = null;
        }
    }

    private synchronized void unregisterSlaveMountpoint() {
        ++this.lastUpdateCount;
        if (this.slaveActorRef != null) {
            LOG.debug("{}: Sending message to unregister slave mountpoint to {}", (Object)this.id, (Object)this.slaveActorRef);
            this.slaveActorRef.tell((Object)new UnregisterSlaveMountPoint(), ActorRef.noSender());
        }
    }

    void registerDataTreeChangeListener(String topologyId, NodeKey key) {
        InstanceIdentifier<Node> path = NetconfTopologyUtils.createTopologyNodeListPath(key, topologyId);
        LOG.debug("{}: Registering data tree change listener on path {}", (Object)this.id, path);
        this.dataChangeListenerRegistration = this.setup.getDataBroker().registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, path), (DataTreeChangeListener)this);
    }

    private synchronized void handleSlaveMountPoint(DataObjectModification<Node> rootNode) {
        if (this.closed) {
            return;
        }
        NetconfNode netconfNodeAfter = (NetconfNode)((Node)rootNode.getDataAfter()).augmentation(NetconfNode.class);
        if (NetconfNodeConnectionStatus.ConnectionStatus.Connected.equals((Object)netconfNodeAfter.getConnectionStatus())) {
            ++this.lastUpdateCount;
            this.createOrUpdateActorRef();
            String masterAddress = netconfNodeAfter.getClusteredConnectionStatus().getNetconfMasterNode();
            String masterActorPath = NetconfTopologyUtils.createActorPath(masterAddress, NetconfTopologyUtils.createMasterActorName(this.id.getName(), netconfNodeAfter.getClusteredConnectionStatus().getNetconfMasterNode()));
            AskForMasterMountPoint askForMasterMountPoint = new AskForMasterMountPoint(this.slaveActorRef);
            ActorSelection masterActor = this.setup.getActorSystem().actorSelection(masterActorPath);
            LOG.debug("{}: Sending {} message to master {}", new Object[]{this.id, askForMasterMountPoint, masterActor});
            this.sendAskForMasterMountPointWithRetries(askForMasterMountPoint, masterActor, 1, this.lastUpdateCount);
        } else {
            this.unregisterSlaveMountpoint();
        }
    }

    @GuardedBy(value="this")
    private void sendAskForMasterMountPointWithRetries(final AskForMasterMountPoint askForMasterMountPoint, final ActorSelection masterActor, final int tries, final int updateCount) {
        Future future = Patterns.ask((ActorSelection)masterActor, (Object)askForMasterMountPoint, (Timeout)this.actorResponseWaitTime);
        future.onComplete((Function1)new OnComplete<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Throwable failure, Object response) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (NetconfNodeManager.this.closed || updateCount != NetconfNodeManager.this.lastUpdateCount) {
                        return;
                    }
                    if (failure instanceof AskTimeoutException) {
                        if (tries <= 5 || tries % 10 == 0) {
                            LOG.warn("{}: Failed to send message to {} - retrying...", new Object[]{NetconfNodeManager.this.id, masterActor, failure});
                        }
                        NetconfNodeManager.this.sendAskForMasterMountPointWithRetries(askForMasterMountPoint, masterActor, tries + 1, updateCount);
                    } else if (failure != null) {
                        LOG.error("{}: Failed to send message {} to {}. Slave mount point could not be created", new Object[]{NetconfNodeManager.this.id, askForMasterMountPoint, masterActor, failure});
                    } else {
                        LOG.debug("{}: {} message to {} succeeded", new Object[]{NetconfNodeManager.this.id, askForMasterMountPoint, masterActor});
                    }
                }
            }
        }, (ExecutionContext)this.setup.getActorSystem().dispatcher());
    }

    @GuardedBy(value="this")
    private void createOrUpdateActorRef() {
        if (this.slaveActorRef == null) {
            this.slaveActorRef = this.setup.getActorSystem().actorOf(NetconfNodeActor.props(this.setup, this.id, this.schemaRegistry, this.schemaRepository, this.actorResponseWaitTime, this.mountPointService));
            LOG.debug("{}: Slave actor created with name {}", (Object)this.id, (Object)this.slaveActorRef);
        } else {
            this.slaveActorRef.tell((Object)new RefreshSlaveActor(this.setup, this.id, this.schemaRegistry, this.schemaRepository, this.actorResponseWaitTime), ActorRef.noSender());
        }
    }

    void refreshDevice(NetconfTopologySetup netconfTopologyDeviceSetup, RemoteDeviceId remoteDeviceId) {
        this.setup = netconfTopologyDeviceSetup;
        this.id = remoteDeviceId;
    }
}

