/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.Cluster;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.api.RemoteDeviceConnector;
import org.opendaylight.netconf.topology.singleton.impl.MasterSalFacade;
import org.opendaylight.netconf.topology.singleton.impl.NetconfNodeManager;
import org.opendaylight.netconf.topology.singleton.impl.RemoteDeviceConnectorImpl;
import org.opendaylight.netconf.topology.singleton.impl.actors.NetconfNodeActor;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologySetup;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologyUtils;
import org.opendaylight.netconf.topology.singleton.messages.RefreshSetupMasterActorData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

class NetconfTopologyContext
implements ClusterSingletonService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyContext.class);
    private final ServiceGroupIdentifier serviceGroupIdent;
    private final Timeout actorResponseWaitTime;
    private final DOMMountPointService mountService;
    private NetconfTopologySetup netconfTopologyDeviceSetup;
    private RemoteDeviceId remoteDeviceId;
    private RemoteDeviceConnector remoteDeviceConnector;
    private NetconfNodeManager netconfNodeManager;
    private ActorRef masterActorRef;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private volatile boolean isMaster;

    NetconfTopologyContext(NetconfTopologySetup netconfTopologyDeviceSetup, ServiceGroupIdentifier serviceGroupIdent, Timeout actorResponseWaitTime, DOMMountPointService mountService) {
        this.netconfTopologyDeviceSetup = (NetconfTopologySetup)Preconditions.checkNotNull((Object)netconfTopologyDeviceSetup);
        this.serviceGroupIdent = serviceGroupIdent;
        this.actorResponseWaitTime = actorResponseWaitTime;
        this.mountService = mountService;
        this.remoteDeviceId = NetconfTopologyUtils.createRemoteDeviceId(netconfTopologyDeviceSetup.getNode().getNodeId(), (NetconfNode)netconfTopologyDeviceSetup.getNode().augmentation(NetconfNode.class));
        this.remoteDeviceConnector = new RemoteDeviceConnectorImpl(netconfTopologyDeviceSetup, this.remoteDeviceId);
        this.netconfNodeManager = this.createNodeDeviceManager();
    }

    public void instantiateServiceInstance() {
        LOG.info("Master was selected: {}", (Object)this.remoteDeviceId.getHost().getIpAddress());
        this.isMaster = true;
        if (this.netconfNodeManager != null) {
            this.netconfNodeManager.close();
            this.netconfNodeManager = null;
        }
        if (!this.closed.get()) {
            String masterAddress = Cluster.get((ActorSystem)this.netconfTopologyDeviceSetup.getActorSystem()).selfAddress().toString();
            this.masterActorRef = this.netconfTopologyDeviceSetup.getActorSystem().actorOf(NetconfNodeActor.props(this.netconfTopologyDeviceSetup, this.remoteDeviceId, (SchemaSourceRegistry)NetconfTopologyUtils.DEFAULT_SCHEMA_REPOSITORY, (SchemaRepository)NetconfTopologyUtils.DEFAULT_SCHEMA_REPOSITORY, this.actorResponseWaitTime, this.mountService), NetconfTopologyUtils.createMasterActorName(this.remoteDeviceId.getName(), masterAddress));
            this.remoteDeviceConnector.startRemoteDeviceConnection(this.newMasterSalFacade());
        }
    }

    public ListenableFuture<Void> closeServiceInstance() {
        if (!this.closed.get()) {
            this.netconfNodeManager = this.createNodeDeviceManager();
        }
        this.stopDeviceConnectorAndActor();
        return Futures.immediateFuture(null);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return this.serviceGroupIdent;
    }

    private NetconfNodeManager createNodeDeviceManager() {
        NetconfNodeManager ndm = new NetconfNodeManager(this.netconfTopologyDeviceSetup, this.remoteDeviceId, this.actorResponseWaitTime, this.mountService);
        ndm.registerDataTreeChangeListener(this.netconfTopologyDeviceSetup.getTopologyId(), this.netconfTopologyDeviceSetup.getNode().key());
        return ndm;
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.netconfNodeManager != null) {
            this.netconfNodeManager.close();
        }
        this.stopDeviceConnectorAndActor();
    }

    void refresh(@Nonnull NetconfTopologySetup setup) {
        this.netconfTopologyDeviceSetup = (NetconfTopologySetup)Preconditions.checkNotNull((Object)setup);
        this.remoteDeviceId = NetconfTopologyUtils.createRemoteDeviceId(this.netconfTopologyDeviceSetup.getNode().getNodeId(), (NetconfNode)this.netconfTopologyDeviceSetup.getNode().augmentation(NetconfNode.class));
        if (this.isMaster) {
            this.remoteDeviceConnector.stopRemoteDeviceConnection();
        }
        if (!this.isMaster) {
            this.netconfNodeManager.refreshDevice(this.netconfTopologyDeviceSetup, this.remoteDeviceId);
        }
        this.remoteDeviceConnector = new RemoteDeviceConnectorImpl(this.netconfTopologyDeviceSetup, this.remoteDeviceId);
        if (this.isMaster) {
            Future future = Patterns.ask((ActorRef)this.masterActorRef, (Object)new RefreshSetupMasterActorData(this.netconfTopologyDeviceSetup, this.remoteDeviceId), (Timeout)this.actorResponseWaitTime);
            future.onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable failure, Object success) {
                    if (failure != null) {
                        LOG.error("Failed to refresh master actor data", failure);
                        return;
                    }
                    NetconfTopologyContext.this.remoteDeviceConnector.startRemoteDeviceConnection(NetconfTopologyContext.this.newMasterSalFacade());
                }
            }, (ExecutionContext)this.netconfTopologyDeviceSetup.getActorSystem().dispatcher());
        }
    }

    private void stopDeviceConnectorAndActor() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        if (this.remoteDeviceConnector != null) {
            this.remoteDeviceConnector.stopRemoteDeviceConnection();
        }
        if (this.masterActorRef != null) {
            this.netconfTopologyDeviceSetup.getActorSystem().stop(this.masterActorRef);
            this.masterActorRef = null;
        }
    }

    protected MasterSalFacade newMasterSalFacade() {
        return new MasterSalFacade(this.remoteDeviceId, this.netconfTopologyDeviceSetup.getActorSystem(), this.masterActorRef, this.actorResponseWaitTime, this.mountService, this.netconfTopologyDeviceSetup.getDataBroker());
    }
}

