/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorSystem;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.EventExecutor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.topology.singleton.api.NetconfTopologySingletonService;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyContext;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologySetup;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologyUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class NetconfTopologyManager
implements ClusteredDataTreeChangeListener<Node>,
NetconfTopologySingletonService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyManager.class);
    private final Map<InstanceIdentifier<Node>, NetconfTopologyContext> contexts = new ConcurrentHashMap<InstanceIdentifier<Node>, NetconfTopologyContext>();
    private final Map<InstanceIdentifier<Node>, ClusterSingletonServiceRegistration> clusterRegistrations = new ConcurrentHashMap<InstanceIdentifier<Node>, ClusterSingletonServiceRegistration>();
    private final DataBroker dataBroker;
    private final DOMRpcProviderService rpcProviderRegistry;
    private final ClusterSingletonServiceProvider clusterSingletonServiceProvider;
    private final ScheduledExecutorService keepaliveExecutor;
    private final ListeningExecutorService processingExecutor;
    private final ActorSystem actorSystem;
    private final EventExecutor eventExecutor;
    private final NetconfClientDispatcher clientDispatcher;
    private final String topologyId;
    private final Duration writeTxIdleTimeout;
    private final DOMMountPointService mountPointService;
    private final AAAEncryptionService encryptionService;
    private ListenerRegistration<NetconfTopologyManager> dataChangeListenerRegistration;
    private String privateKeyPath;
    private String privateKeyPassphrase;

    public NetconfTopologyManager(DataBroker dataBroker, DOMRpcProviderService rpcProviderRegistry, ClusterSingletonServiceProvider clusterSingletonServiceProvider, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, ActorSystemProvider actorSystemProvider, EventExecutor eventExecutor, NetconfClientDispatcher clientDispatcher, String topologyId, Config config, DOMMountPointService mountPointService, AAAEncryptionService encryptionService) {
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.rpcProviderRegistry = (DOMRpcProviderService)Preconditions.checkNotNull((Object)rpcProviderRegistry);
        this.clusterSingletonServiceProvider = (ClusterSingletonServiceProvider)Preconditions.checkNotNull((Object)clusterSingletonServiceProvider);
        this.keepaliveExecutor = keepaliveExecutor.getExecutor();
        this.processingExecutor = MoreExecutors.listeningDecorator((ExecutorService)processingExecutor.getExecutor());
        this.actorSystem = ((ActorSystemProvider)Preconditions.checkNotNull((Object)actorSystemProvider)).getActorSystem();
        this.eventExecutor = (EventExecutor)Preconditions.checkNotNull((Object)eventExecutor);
        this.clientDispatcher = (NetconfClientDispatcher)Preconditions.checkNotNull((Object)clientDispatcher);
        this.topologyId = (String)Preconditions.checkNotNull((Object)topologyId);
        this.writeTxIdleTimeout = Duration.apply((long)config.getWriteTransactionIdleTimeout().intValue(), (TimeUnit)TimeUnit.SECONDS);
        this.mountPointService = mountPointService;
        this.encryptionService = (AAAEncryptionService)Preconditions.checkNotNull((Object)encryptionService);
    }

    public void init() {
        this.dataChangeListenerRegistration = this.registerDataTreeChangeListener();
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Node>> changes) {
        block5: for (DataTreeModification<Node> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            InstanceIdentifier dataModifIdent = change.getRootPath().getRootIdentifier();
            NodeId nodeId = NetconfTopologyUtils.getNodeId(rootNode.getIdentifier());
            switch (rootNode.getModificationType()) {
                case SUBTREE_MODIFIED: {
                    LOG.debug("Config for node {} updated", (Object)nodeId);
                    this.refreshNetconfDeviceContext((InstanceIdentifier<Node>)dataModifIdent, (Node)rootNode.getDataAfter());
                    continue block5;
                }
                case WRITE: {
                    if (this.contexts.containsKey(dataModifIdent)) {
                        LOG.debug("RemoteDevice{{}} was already configured, reconfiguring node...", (Object)nodeId);
                        this.refreshNetconfDeviceContext((InstanceIdentifier<Node>)dataModifIdent, (Node)rootNode.getDataAfter());
                        continue block5;
                    }
                    LOG.debug("Config for node {} created", (Object)nodeId);
                    this.startNetconfDeviceContext((InstanceIdentifier<Node>)dataModifIdent, (Node)rootNode.getDataAfter());
                    continue block5;
                }
                case DELETE: {
                    LOG.debug("Config for node {} deleted", (Object)nodeId);
                    this.stopNetconfDeviceContext((InstanceIdentifier<Node>)dataModifIdent);
                    continue block5;
                }
            }
            LOG.warn("Unknown operation for {}.", (Object)nodeId);
        }
    }

    private void refreshNetconfDeviceContext(InstanceIdentifier<Node> instanceIdentifier, Node node) {
        NetconfTopologyContext context = this.contexts.get(instanceIdentifier);
        context.refresh(this.createSetup(instanceIdentifier, node));
    }

    private void startNetconfDeviceContext(InstanceIdentifier<Node> instanceIdentifier, Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        Preconditions.checkNotNull((Object)netconfNode);
        Preconditions.checkNotNull((Object)netconfNode.getHost());
        Preconditions.checkNotNull((Object)netconfNode.getHost().getIpAddress());
        Timeout actorResponseWaitTime = new Timeout(Duration.create((long)netconfNode.getActorResponseWaitTime().intValue(), (String)"seconds"));
        ServiceGroupIdentifier serviceGroupIdent = ServiceGroupIdentifier.create((String)instanceIdentifier.toString());
        NetconfTopologyContext newNetconfTopologyContext = this.newNetconfTopologyContext(this.createSetup(instanceIdentifier, node), serviceGroupIdent, actorResponseWaitTime);
        int tries = 3;
        while (true) {
            try {
                ClusterSingletonServiceRegistration clusterSingletonServiceRegistration = this.clusterSingletonServiceProvider.registerClusterSingletonService((ClusterSingletonService)newNetconfTopologyContext);
                this.clusterRegistrations.put(instanceIdentifier, clusterSingletonServiceRegistration);
                this.contexts.put(instanceIdentifier, newNetconfTopologyContext);
            }
            catch (RuntimeException e) {
                LOG.warn("Unable to register cluster singleton service {}, trying again", (Object)newNetconfTopologyContext, (Object)e);
                if (--tries > 0) continue;
                LOG.error("Unable to register cluster singleton service {} - done trying, closing topology context", (Object)newNetconfTopologyContext, (Object)e);
                NetconfTopologyManager.close(newNetconfTopologyContext);
            }
            break;
        }
    }

    private void stopNetconfDeviceContext(InstanceIdentifier<Node> instanceIdentifier) {
        NetconfTopologyContext netconfTopologyContext = this.contexts.remove(instanceIdentifier);
        if (netconfTopologyContext != null) {
            NetconfTopologyManager.close((AutoCloseable)this.clusterRegistrations.remove(instanceIdentifier));
            NetconfTopologyManager.close(netconfTopologyContext);
        }
    }

    @VisibleForTesting
    protected NetconfTopologyContext newNetconfTopologyContext(NetconfTopologySetup setup, ServiceGroupIdentifier serviceGroupIdent, Timeout actorResponseWaitTime) {
        return new NetconfTopologyContext(setup, serviceGroupIdent, actorResponseWaitTime, this.mountPointService);
    }

    @Override
    public void close() {
        if (this.dataChangeListenerRegistration != null) {
            this.dataChangeListenerRegistration.close();
            this.dataChangeListenerRegistration = null;
        }
        this.contexts.values().forEach(NetconfTopologyManager::close);
        this.clusterRegistrations.values().forEach(NetconfTopologyManager::close);
        this.contexts.clear();
        this.clusterRegistrations.clear();
    }

    private static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing {}", (Object)closeable, (Object)e);
        }
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    private ListenerRegistration<NetconfTopologyManager> registerDataTreeChangeListener() {
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        this.initTopology(wtx, LogicalDatastoreType.CONFIGURATION);
        this.initTopology(wtx, LogicalDatastoreType.OPERATIONAL);
        wtx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("topology initialization successful");
            }

            public void onFailure(@Nonnull Throwable throwable) {
                LOG.error("Unable to initialize netconf-topology", throwable);
            }
        }, MoreExecutors.directExecutor());
        LOG.debug("Registering datastore listener");
        return this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)NetconfTopologyUtils.createTopologyListPath(this.topologyId).child(Node.class)), (DataTreeChangeListener)this);
    }

    private void initTopology(WriteTransaction wtx, LogicalDatastoreType datastoreType) {
        NetworkTopology networkTopology = new NetworkTopologyBuilder().build();
        InstanceIdentifier networkTopologyId = InstanceIdentifier.builder(NetworkTopology.class).build();
        wtx.merge(datastoreType, networkTopologyId, (DataObject)networkTopology);
        Topology topology = new TopologyBuilder().setTopologyId(new TopologyId(this.topologyId)).build();
        wtx.merge(datastoreType, (InstanceIdentifier)networkTopologyId.child(Topology.class, (Identifier)new TopologyKey(new TopologyId(this.topologyId))), (DataObject)topology);
    }

    private NetconfTopologySetup createSetup(InstanceIdentifier<Node> instanceIdentifier, Node node) {
        NetconfTopologySetup.NetconfTopologySetupBuilder builder = NetconfTopologySetup.NetconfTopologySetupBuilder.create().setClusterSingletonServiceProvider(this.clusterSingletonServiceProvider).setDataBroker(this.dataBroker).setInstanceIdentifier(instanceIdentifier).setRpcProviderRegistry(this.rpcProviderRegistry).setNode(node).setActorSystem(this.actorSystem).setEventExecutor(this.eventExecutor).setKeepaliveExecutor(this.keepaliveExecutor).setProcessingExecutor(this.processingExecutor).setTopologyId(this.topologyId).setNetconfClientDispatcher(this.clientDispatcher).setSchemaResourceDTO(NetconfTopologyUtils.setupSchemaCacheDTO(node)).setIdleTimeout(this.writeTxIdleTimeout).setPrivateKeyPath(this.privateKeyPath).setPrivateKeyPassphrase(this.privateKeyPassphrase).setEncryptionService(this.encryptionService);
        return builder.build();
    }
}

