/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.utils.ClusteringRpcException;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.netconf.topology.singleton.messages.SchemaPathMessage;
import org.opendaylight.netconf.topology.singleton.messages.rpc.InvokeRpcMessage;
import org.opendaylight.netconf.topology.singleton.messages.rpc.InvokeRpcMessageReply;
import org.opendaylight.netconf.topology.singleton.messages.transactions.EmptyResultResponse;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ProxyDOMRpcService
implements DOMRpcService {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyDOMRpcService.class);
    private final ActorRef masterActorRef;
    private final ActorSystem actorSystem;
    private final RemoteDeviceId id;
    private final Timeout actorResponseWaitTime;

    public ProxyDOMRpcService(ActorSystem actorSystem, ActorRef masterActorRef, RemoteDeviceId remoteDeviceId, Timeout actorResponseWaitTime) {
        this.actorSystem = actorSystem;
        this.masterActorRef = masterActorRef;
        this.id = remoteDeviceId;
        this.actorResponseWaitTime = actorResponseWaitTime;
    }

    public FluentFuture<DOMRpcResult> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        LOG.trace("{}: Rpc operation invoked with schema type: {} and node: {}.", new Object[]{this.id, type, input});
        NormalizedNodeMessage normalizedNodeMessage = input != null ? new NormalizedNodeMessage(YangInstanceIdentifier.EMPTY, input) : null;
        Future scalaFuture = Patterns.ask((ActorRef)this.masterActorRef, (Object)new InvokeRpcMessage(new SchemaPathMessage(type), normalizedNodeMessage), (Timeout)this.actorResponseWaitTime);
        final SettableFuture settableFuture = SettableFuture.create();
        scalaFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    if (failure instanceof ClusteringRpcException) {
                        settableFuture.setException(failure);
                    } else {
                        settableFuture.setException((Throwable)((Object)new ClusteringRpcException(ProxyDOMRpcService.this.id + ": Exception during remote rpc invocation.", failure)));
                    }
                    return;
                }
                if (response instanceof EmptyResultResponse) {
                    settableFuture.set(null);
                    return;
                }
                Collection<? extends RpcError> errors = ((InvokeRpcMessageReply)response).getRpcErrors();
                NormalizedNodeMessage normalizedNodeMessageResult = ((InvokeRpcMessageReply)response).getNormalizedNodeMessage();
                DefaultDOMRpcResult result = normalizedNodeMessageResult == null ? new DefaultDOMRpcResult((Collection)ImmutableList.copyOf(errors)) : new DefaultDOMRpcResult(normalizedNodeMessageResult.getNode(), errors);
                settableFuture.set((Object)result);
            }
        }, (ExecutionContext)this.actorSystem.dispatcher());
        return settableFuture;
    }

    @Nonnull
    public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T listener) {
        throw new UnsupportedOperationException("RegisterRpcListener: DOMRpc service not working in cluster.");
    }
}

