/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.schema.provider.RemoteYangTextSourceProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.YangTextSchemaSourceSerializationProxy;
import org.opendaylight.netconf.topology.singleton.messages.YangTextSchemaSourceRequest;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.impl.Promise;

public class ProxyYangTextSourceProvider
implements RemoteYangTextSourceProvider {
    private final ActorRef masterRef;
    private final ExecutionContext executionContext;
    private final Timeout actorResponseWaitTime;

    public ProxyYangTextSourceProvider(ActorRef masterRef, ExecutionContext executionContext, Timeout actorResponseWaitTime) {
        this.masterRef = masterRef;
        this.executionContext = executionContext;
        this.actorResponseWaitTime = actorResponseWaitTime;
    }

    public Future<Set<SourceIdentifier>> getProvidedSources() {
        return Futures.successful(Collections.emptySet());
    }

    public Future<YangTextSchemaSourceSerializationProxy> getYangTextSchemaSource(@Nonnull SourceIdentifier sourceIdentifier) {
        Future scalaFuture = Patterns.ask((ActorRef)this.masterRef, (Object)new YangTextSchemaSourceRequest(sourceIdentifier), (Timeout)this.actorResponseWaitTime);
        final Promise.DefaultPromise promise = new Promise.DefaultPromise();
        scalaFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                if (failure != null) {
                    promise.failure(failure);
                    return;
                }
                promise.success((Object)((YangTextSchemaSourceSerializationProxy)success));
            }
        }, this.executionContext);
        return promise.future();
    }
}

