/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.actors;

import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedAbstractActor;
import akka.japi.Creator;
import java.io.Serializable;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.netconf.topology.singleton.impl.actors.ReadAdapter;
import org.opendaylight.netconf.topology.singleton.impl.actors.WriteAdapter;
import org.opendaylight.netconf.topology.singleton.messages.transactions.ReadActorMessage;
import org.opendaylight.netconf.topology.singleton.messages.transactions.WriteActorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public final class ReadWriteTransactionActor
extends UntypedAbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteTransactionActor.class);
    private final DOMDataTreeReadWriteTransaction tx;
    private final long idleTimeout;
    private final ReadAdapter readAdapter;
    private final WriteAdapter writeAdapter;

    private ReadWriteTransactionActor(DOMDataTreeReadWriteTransaction tx, Duration idleTimeout) {
        this.tx = tx;
        this.idleTimeout = idleTimeout.toSeconds();
        if (this.idleTimeout > 0L) {
            this.context().setReceiveTimeout(idleTimeout);
        }
        this.readAdapter = new ReadAdapter((DOMDataTreeReadTransaction)tx);
        this.writeAdapter = new WriteAdapter((DOMDataTreeWriteTransaction)tx);
    }

    static Props props(DOMDataTreeReadWriteTransaction tx, Duration idleTimeout) {
        return Props.create(ReadWriteTransactionActor.class, (Creator & Serializable)() -> new ReadWriteTransactionActor(tx, idleTimeout));
    }

    public void onReceive(Object message) {
        if (message instanceof ReadActorMessage) {
            this.readAdapter.handle(message, this.sender(), this.self());
        } else if (message instanceof WriteActorMessage) {
            this.writeAdapter.handle(message, this.sender(), this.context(), this.self());
        } else if (message instanceof ReceiveTimeout) {
            LOG.warn("Haven't received any message for {} seconds, cancelling transaction and stopping actor", (Object)this.idleTimeout);
            this.tx.cancel();
            this.context().stop(this.self());
        } else {
            this.unhandled(message);
        }
    }
}

