/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.actors;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Status;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.netconf.topology.singleton.messages.transactions.CancelRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.DeleteRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.MergeRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.PutRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.SubmitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WriteAdapter.class);
    private final DOMDataTreeWriteTransaction tx;

    WriteAdapter(DOMDataTreeWriteTransaction tx) {
        this.tx = tx;
    }

    private void cancel(ActorContext context, ActorRef sender, ActorRef self) {
        boolean cancelled = this.tx.cancel();
        sender.tell((Object)cancelled, self);
        context.stop(self);
    }

    private void submit(final ActorRef requester, final ActorRef self, ActorContext context) {
        FluentFuture submitFuture = this.tx.commit();
        context.stop(self);
        submitFuture.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                requester.tell((Object)new Status.Success(null), self);
            }

            public void onFailure(@Nonnull Throwable throwable) {
                requester.tell((Object)new Status.Failure(throwable), self);
            }
        }, MoreExecutors.directExecutor());
    }

    public void handle(Object message, ActorRef sender, ActorContext context, ActorRef self) {
        try {
            if (message instanceof MergeRequest) {
                MergeRequest mergeRequest = (MergeRequest)message;
                NormalizedNodeMessage data = mergeRequest.getNormalizedNodeMessage();
                this.tx.merge(mergeRequest.getStore(), data.getIdentifier(), data.getNode());
            } else if (message instanceof PutRequest) {
                PutRequest putRequest = (PutRequest)message;
                NormalizedNodeMessage data = putRequest.getNormalizedNodeMessage();
                this.tx.put(putRequest.getStore(), data.getIdentifier(), data.getNode());
            } else if (message instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)message;
                this.tx.delete(deleteRequest.getStore(), deleteRequest.getPath());
            } else if (message instanceof CancelRequest) {
                this.cancel(context, sender, self);
            } else if (message instanceof SubmitRequest) {
                this.submit(sender, self, context);
            }
        }
        catch (RuntimeException exception) {
            LOG.error("Write command has failed.", (Throwable)exception);
        }
    }
}

