/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.tx;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.tx.ProxyTransactionFacade;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FailedProxyTransactionFacade
implements ProxyTransactionFacade {
    private static final Logger LOG = LoggerFactory.getLogger(FailedProxyTransactionFacade.class);
    private final RemoteDeviceId id;
    private final Throwable failure;

    FailedProxyTransactionFacade(RemoteDeviceId id, Throwable failure) {
        this.id = Objects.requireNonNull(id);
        this.failure = Objects.requireNonNull(failure);
    }

    public Object getIdentifier() {
        return this.id;
    }

    public boolean cancel() {
        return true;
    }

    public void close() {
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Read {} {} - failure", new Object[]{this.id, store, path, this.failure});
        return FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply(this.failure instanceof Exception ? (Exception)this.failure : new ReadFailedException("read", this.failure, new RpcError[0])));
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Exists {} {} - failure", new Object[]{this.id, store, path, this.failure});
        return FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply(this.failure instanceof Exception ? (Exception)this.failure : new ReadFailedException("read", this.failure, new RpcError[0])));
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Delete {} {} - failure", new Object[]{this.id, store, path, this.failure});
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        LOG.debug("{}: Put {} {} - failure", new Object[]{this.id, store, path, this.failure});
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        LOG.debug("{}: Merge {} {} - failure", new Object[]{this.id, store, path, this.failure});
    }

    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit() {
        LOG.debug("{}: Commit - failure", (Object)this.id, (Object)this.failure);
        TransactionCommitFailedException txCommitEx = this.failure instanceof TransactionCommitFailedException ? (TransactionCommitFailedException)this.failure : new TransactionCommitFailedException("commit", this.failure, new RpcError[0]);
        return FluentFutures.immediateFailedFluentFuture((Throwable)txCommitEx);
    }
}

