/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.tx;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.tx.ActorProxyTransactionFacade;
import org.opendaylight.netconf.topology.singleton.impl.tx.FailedProxyTransactionFacade;
import org.opendaylight.netconf.topology.singleton.impl.tx.ProxyTransactionFacade;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ProxyReadWriteTransaction
implements DOMDataTreeReadWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyReadWriteTransaction.class);
    private final RemoteDeviceId id;
    private final AtomicBoolean opened = new AtomicBoolean(true);
    @GuardedBy(value="queuedTxOperations")
    private final List<Consumer<ProxyTransactionFacade>> queuedTxOperations = new ArrayList<Consumer<ProxyTransactionFacade>>();
    private volatile ProxyTransactionFacade transactionFacade;

    public ProxyReadWriteTransaction(final RemoteDeviceId id, Future<Object> masterTxActorFuture, final ExecutionContext executionContext, final Timeout askTimeout) {
        this.id = id;
        masterTxActorFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object masterTxActor) {
                ProxyTransactionFacade newTransactionFacade;
                if (failure != null) {
                    LOG.debug("{}: Failed to obtain master actor", (Object)id, (Object)failure);
                    newTransactionFacade = new FailedProxyTransactionFacade(id, failure);
                } else {
                    LOG.debug("{}: Obtained master actor {}", (Object)id, masterTxActor);
                    newTransactionFacade = new ActorProxyTransactionFacade((ActorRef)masterTxActor, id, executionContext, askTimeout);
                }
                ProxyReadWriteTransaction.this.executePriorTransactionOperations(newTransactionFacade);
            }
        }, executionContext);
    }

    public boolean cancel() {
        if (!this.opened.compareAndSet(true, false)) {
            return false;
        }
        this.processTransactionOperation(DOMDataTreeWriteTransaction::cancel);
        return true;
    }

    public void close() {
        this.cancel();
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Read {} {}", new Object[]{this.id, store, path});
        SettableFuture returnFuture = SettableFuture.create();
        this.processTransactionOperation(facade -> returnFuture.setFuture((ListenableFuture)facade.read(store, path)));
        return returnFuture;
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Exists {} {}", new Object[]{this.id, store, path});
        SettableFuture returnFuture = SettableFuture.create();
        this.processTransactionOperation(facade -> returnFuture.setFuture((ListenableFuture)facade.exists(store, path)));
        return returnFuture;
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkOpen();
        LOG.debug("{}: Delete {} {}", new Object[]{this.id, store, path});
        this.processTransactionOperation(facade -> facade.delete(store, path));
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkOpen();
        LOG.debug("{}: Put {} {}", new Object[]{this.id, store, path});
        this.processTransactionOperation(facade -> facade.put(store, path, data));
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkOpen();
        LOG.debug("{}: Merge {} {}", new Object[]{this.id, store, path});
        this.processTransactionOperation(facade -> facade.merge(store, path, data));
    }

    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit() {
        Preconditions.checkState((boolean)this.opened.compareAndSet(true, false), (String)"%s: Transaction is already closed", (Object)this.id);
        LOG.debug("{}: Commit", (Object)this.id);
        SettableFuture returnFuture = SettableFuture.create();
        this.processTransactionOperation(facade -> returnFuture.setFuture((ListenableFuture)facade.commit()));
        return returnFuture;
    }

    public Object getIdentifier() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransactionOperation(Consumer<ProxyTransactionFacade> operation) {
        ProxyTransactionFacade facadeOnEntry;
        List<Consumer<ProxyTransactionFacade>> list = this.queuedTxOperations;
        synchronized (list) {
            if (this.transactionFacade == null) {
                LOG.debug("{}: Queuing transaction operation", (Object)this.id);
                this.queuedTxOperations.add(operation);
                facadeOnEntry = null;
            } else {
                facadeOnEntry = this.transactionFacade;
            }
        }
        if (facadeOnEntry != null) {
            operation.accept(facadeOnEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePriorTransactionOperations(ProxyTransactionFacade newTransactionFacade) {
        block3: while (true) {
            ArrayList<Consumer<ProxyTransactionFacade>> operationsBatch;
            Object object = this.queuedTxOperations;
            synchronized (object) {
                if (this.queuedTxOperations.isEmpty()) {
                    this.transactionFacade = newTransactionFacade;
                    break;
                }
                operationsBatch = new ArrayList<Consumer<ProxyTransactionFacade>>(this.queuedTxOperations);
                this.queuedTxOperations.clear();
            }
            object = operationsBatch.iterator();
            while (true) {
                if (!object.hasNext()) continue block3;
                Consumer oper = (Consumer)object.next();
                oper.accept(newTransactionFacade);
            }
            break;
        }
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.opened.get(), (String)"%s: Transaction is closed", (Object)this.id);
    }
}

