/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.utils;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemasResolver;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDevice;
import org.opendaylight.netconf.sal.connect.netconf.NetconfStateSchemasResolverImpl;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.FilesystemSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.util.InMemorySchemaSourceCache;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToASTTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfTopologyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyUtils.class);
    private static final String DEFAULT_SCHEMA_REPOSITORY_NAME = "sal-netconf-connector";
    public static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 60000L;
    public static final int DEFAULT_KEEPALIVE_DELAY = 0;
    public static final boolean DEFAULT_RECONNECT_ON_CHANGED_SCHEMA = false;
    public static final int DEFAULT_CONCURRENT_RPC_LIMIT = 0;
    public static final int DEFAULT_MAX_CONNECTION_ATTEMPTS = 0;
    public static final int DEFAULT_BETWEEN_ATTEMPTS_TIMEOUT_MILLIS = 2000;
    public static final long DEFAULT_CONNECTION_TIMEOUT_MILLIS = 20000L;
    public static final BigDecimal DEFAULT_SLEEP_FACTOR = new BigDecimal(1.5);
    public static final String DEFAULT_CACHE_DIRECTORY = "schema";
    public static final String CACHE_DIRECTORY = "cache";
    public static final String QUALIFIED_DEFAULT_CACHE_DIRECTORY = "cache" + File.separator + "schema";
    public static final SharedSchemaRepository DEFAULT_SCHEMA_REPOSITORY = new SharedSchemaRepository("sal-netconf-connector");
    public static final InMemorySchemaSourceCache<ASTSchemaSource> DEFAULT_AST_CACHE = InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, ASTSchemaSource.class);
    public static final SchemaContextFactory DEFAULT_SCHEMA_CONTEXT_FACTORY = DEFAULT_SCHEMA_REPOSITORY.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
    private static final Map<String, NetconfDevice.SchemaResourcesDTO> SCHEMA_RESOURCES_DTO_MAP = new HashMap<String, NetconfDevice.SchemaResourcesDTO>();

    private NetconfTopologyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetconfDevice.SchemaResourcesDTO setupSchemaCacheDTO(Node node) {
        Map<String, NetconfDevice.SchemaResourcesDTO> map;
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        String moduleSchemaCacheDirectory = netconfNode.getSchemaCacheDirectory();
        RemoteDeviceId deviceId = NetconfTopologyUtils.createRemoteDeviceId(node.getNodeId(), netconfNode);
        NetconfDevice.SchemaResourcesDTO schemaResourcesDTO = null;
        if (!Strings.isNullOrEmpty((String)moduleSchemaCacheDirectory) && !moduleSchemaCacheDirectory.equals(DEFAULT_CACHE_DIRECTORY)) {
            map = SCHEMA_RESOURCES_DTO_MAP;
            synchronized (map) {
                schemaResourcesDTO = SCHEMA_RESOURCES_DTO_MAP.get(moduleSchemaCacheDirectory);
                if (schemaResourcesDTO == null) {
                    schemaResourcesDTO = NetconfTopologyUtils.createSchemaResourcesDTO(moduleSchemaCacheDirectory);
                    schemaResourcesDTO.getSchemaRegistry().registerSchemaSourceListener((SchemaSourceListener)TextToASTTransformer.create((SchemaRepository)((SchemaRepository)schemaResourcesDTO.getSchemaRegistry()), (SchemaSourceRegistry)schemaResourcesDTO.getSchemaRegistry()));
                    SCHEMA_RESOURCES_DTO_MAP.put(moduleSchemaCacheDirectory, schemaResourcesDTO);
                }
            }
            LOG.info("{} : netconf connector will use schema cache directory {} instead of {}", new Object[]{deviceId, moduleSchemaCacheDirectory, DEFAULT_CACHE_DIRECTORY});
        }
        if (schemaResourcesDTO == null) {
            map = SCHEMA_RESOURCES_DTO_MAP;
            synchronized (map) {
                schemaResourcesDTO = SCHEMA_RESOURCES_DTO_MAP.get(DEFAULT_CACHE_DIRECTORY);
            }
            LOG.info("{} : using the default directory {}", (Object)deviceId, (Object)QUALIFIED_DEFAULT_CACHE_DIRECTORY);
        }
        return schemaResourcesDTO;
    }

    private static NetconfDevice.SchemaResourcesDTO createSchemaResourcesDTO(String moduleSchemaCacheDirectory) {
        SharedSchemaRepository repository = new SharedSchemaRepository(moduleSchemaCacheDirectory);
        SchemaContextFactory schemaContextFactory = repository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
        FilesystemSchemaSourceCache<YangTextSchemaSource> deviceCache = NetconfTopologyUtils.createDeviceFilesystemCache(moduleSchemaCacheDirectory, (SchemaSourceRegistry)repository);
        repository.registerSchemaSourceListener(deviceCache);
        repository.registerSchemaSourceListener((SchemaSourceListener)InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)repository, ASTSchemaSource.class));
        return new NetconfDevice.SchemaResourcesDTO((SchemaSourceRegistry)repository, (SchemaRepository)repository, schemaContextFactory, (NetconfDeviceSchemasResolver)new NetconfStateSchemasResolverImpl());
    }

    private static FilesystemSchemaSourceCache<YangTextSchemaSource> createDeviceFilesystemCache(String schemaCacheDirectory, SchemaSourceRegistry schemaRegistry) {
        String relativeSchemaCacheDirectory = CACHE_DIRECTORY + File.separator + schemaCacheDirectory;
        return new FilesystemSchemaSourceCache(schemaRegistry, YangTextSchemaSource.class, new File(relativeSchemaCacheDirectory));
    }

    public static RemoteDeviceId createRemoteDeviceId(NodeId nodeId, NetconfNode node) {
        IpAddress ipAddress = node.getHost().getIpAddress();
        InetSocketAddress address = new InetSocketAddress(ipAddress.getIpv4Address() != null ? ipAddress.getIpv4Address().getValue() : ipAddress.getIpv6Address().getValue(), (int)node.getPort().getValue());
        return new RemoteDeviceId(nodeId.getValue(), address);
    }

    public static String createActorPath(String masterMember, String name) {
        return masterMember + "/user/" + name;
    }

    public static String createMasterActorName(String name, String masterAddress) {
        return masterAddress.replaceAll("//", "") + "_" + name;
    }

    public static NodeId getNodeId(InstanceIdentifier.PathArgument pathArgument) {
        Identifier key;
        if (pathArgument instanceof InstanceIdentifier.IdentifiableItem && (key = ((InstanceIdentifier.IdentifiableItem)pathArgument).getKey()) instanceof NodeKey) {
            return ((NodeKey)key).getNodeId();
        }
        throw new IllegalStateException("Unable to create NodeId from: " + pathArgument);
    }

    public static KeyedInstanceIdentifier<Topology, TopologyKey> createTopologyListPath(String topologyId) {
        InstanceIdentifier networkTopology = InstanceIdentifier.create(NetworkTopology.class);
        return networkTopology.child(Topology.class, (Identifier)new TopologyKey(new TopologyId(topologyId)));
    }

    public static InstanceIdentifier<Node> createTopologyNodeListPath(NodeKey key, String topologyId) {
        return NetconfTopologyUtils.createTopologyListPath(topologyId).child(Node.class, (Identifier)new NodeKey(new NodeId(key.getNodeId().getValue())));
    }

    public static InstanceIdentifier<Node> createTopologyNodePath(String topologyId) {
        return NetconfTopologyUtils.createTopologyListPath(topologyId).child(Node.class);
    }

    public static DocumentedException createMasterIsDownException(RemoteDeviceId id, Exception cause) {
        return new DocumentedException(id + ":Master is down. Please try again.", cause, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.WARNING);
    }

    static {
        SCHEMA_RESOURCES_DTO_MAP.put(DEFAULT_CACHE_DIRECTORY, new NetconfDevice.SchemaResourcesDTO((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, (SchemaRepository)DEFAULT_SCHEMA_REPOSITORY, DEFAULT_SCHEMA_CONTEXT_FACTORY, (NetconfDeviceSchemasResolver)new NetconfStateSchemasResolverImpl()));
        DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener(DEFAULT_AST_CACHE);
        DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener((SchemaSourceListener)TextToASTTransformer.create((SchemaRepository)DEFAULT_SCHEMA_REPOSITORY, (SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY));
        int tries = 1;
        while (true) {
            try {
                FilesystemSchemaSourceCache defaultCache = new FilesystemSchemaSourceCache((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, YangTextSchemaSource.class, new File(QUALIFIED_DEFAULT_CACHE_DIRECTORY));
                DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener((SchemaSourceListener)defaultCache);
            }
            catch (IllegalArgumentException e) {
                if (tries++ >= 3) {
                    LOG.error("Error creating default schema cache", (Throwable)e);
                    break;
                }
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            break;
        }
    }
}

