/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class NormalizedNodeMessage
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private YangInstanceIdentifier identifier = null;
    private NormalizedNode<?, ?> node = null;
    private static final SerializationUtils.Applier<NormalizedNodeMessage> APPLIER = (instance, path, node) -> {
        instance.identifier = path;
        instance.node = node;
    };

    public NormalizedNodeMessage() {
    }

    public NormalizedNodeMessage(YangInstanceIdentifier identifier, NormalizedNode<?, ?> node) {
        this.identifier = identifier;
        this.node = node;
    }

    public YangInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public NormalizedNode<?, ?> getNode() {
        return this.node;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        SerializationUtils.serializePathAndNode((YangInstanceIdentifier)this.getIdentifier(), this.node, (DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) {
        SerializationUtils.deserializePathAndNode((DataInput)in, (Object)this, APPLIER);
    }

    public String toString() {
        return "NormalizedNodeMessage [identifier=" + this.identifier + ", node=" + this.node + "]";
    }
}

