/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.messages;

import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class SchemaPathMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final SchemaPath schemaPath;

    public SchemaPathMessage(SchemaPath schemaPath) {
        this.schemaPath = schemaPath;
    }

    public SchemaPath getSchemaPath() {
        return this.schemaPath;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return "SchemaPathMessage [schemaPath=" + this.schemaPath + "]";
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 2L;
        private SchemaPathMessage schemaPathMessage;

        public Proxy() {
        }

        Proxy(SchemaPathMessage schemaPathMessage) {
            this.schemaPathMessage = schemaPathMessage;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(Iterables.size((Iterable)this.schemaPathMessage.getSchemaPath().getPathTowardsRoot()));
            for (QName qualifiedName : this.schemaPathMessage.getSchemaPath().getPathTowardsRoot()) {
                out.writeObject(qualifiedName);
            }
            out.writeBoolean(this.schemaPathMessage.getSchemaPath().isAbsolute());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int sizePath = in.readInt();
            QName[] paths = new QName[sizePath];
            for (int i = 0; i < sizePath; ++i) {
                paths[i] = (QName)in.readObject();
            }
            boolean absolute = in.readBoolean();
            this.schemaPathMessage = new SchemaPathMessage(SchemaPath.create((boolean)absolute, (QName[])paths));
        }

        private Object readResolve() {
            return this.schemaPathMessage;
        }
    }
}

