/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.messages.rpc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.yangtools.yang.common.RpcError;

public class InvokeRpcMessageReply
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Collection<? extends RpcError> rpcErrors;
    private final NormalizedNodeMessage normalizedNodeMessage;

    public InvokeRpcMessageReply(@Nullable NormalizedNodeMessage normalizedNodeMessage, @Nonnull Collection<? extends RpcError> rpcErrors) {
        this.normalizedNodeMessage = normalizedNodeMessage;
        this.rpcErrors = Objects.requireNonNull(rpcErrors);
    }

    @Nullable
    public NormalizedNodeMessage getNormalizedNodeMessage() {
        return this.normalizedNodeMessage;
    }

    @Nonnull
    public Collection<? extends RpcError> getRpcErrors() {
        return this.rpcErrors;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 2L;
        private InvokeRpcMessageReply invokeRpcMessageReply;

        public Proxy() {
        }

        Proxy(InvokeRpcMessageReply invokeRpcMessageReply) {
            this.invokeRpcMessageReply = invokeRpcMessageReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.invokeRpcMessageReply.getRpcErrors().size());
            for (RpcError rpcError : this.invokeRpcMessageReply.getRpcErrors()) {
                out.writeObject(rpcError);
            }
            out.writeObject(this.invokeRpcMessageReply.getNormalizedNodeMessage());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LinkedList<RpcError> rpcErrors = new LinkedList<RpcError>();
            for (int i = 0; i < size; ++i) {
                rpcErrors.add((RpcError)in.readObject());
            }
            NormalizedNodeMessage normalizedNodeMessage = (NormalizedNodeMessage)in.readObject();
            this.invokeRpcMessageReply = new InvokeRpcMessageReply(normalizedNodeMessage, rpcErrors);
        }

        private Object readResolve() {
            return this.invokeRpcMessageReply;
        }
    }
}

