/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NodeId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link.Destination;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationBuilder
implements Builder<Destination> {
    private NodeId _destNode;
    private Object _destTp;
    Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();

    public DestinationBuilder() {
    }

    public DestinationBuilder(Destination base) {
        Map aug;
        this._destNode = base.getDestNode();
        this._destTp = base.getDestTp();
        if (base instanceof DestinationImpl) {
            DestinationImpl impl = (DestinationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(aug);
        }
    }

    public NodeId getDestNode() {
        return this._destNode;
    }

    public Object getDestTp() {
        return this._destTp;
    }

    public <E extends Augmentation<Destination>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DestinationBuilder setDestNode(NodeId value) {
        this._destNode = value;
        return this;
    }

    public DestinationBuilder setDestTp(Object value) {
        this._destTp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DestinationBuilder removeAugmentation(Class<? extends Augmentation<Destination>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    implements Destination {
        private final NodeId _destNode;
        private final Object _destTp;
        private Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DestinationImpl(DestinationBuilder base) {
            this._destNode = base.getDestNode();
            this._destTp = base.getDestTp();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Destination> getImplementedInterface() {
            return Destination.class;
        }

        @Override
        public NodeId getDestNode() {
            return this._destNode;
        }

        @Override
        public Object getDestTp() {
            return this._destTp;
        }

        public <E extends Augmentation<Destination>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destNode);
            result = 31 * result + Objects.hashCode(this._destTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Destination.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Destination other = (Destination)obj;
            if (!Objects.equals(this._destNode, other.getDestNode())) {
                return false;
            }
            if (!Objects.equals(this._destTp, other.getDestTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DestinationImpl otherImpl = (DestinationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Destination");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destNode", (Object)this._destNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destTp", (Object)this._destTp);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

