/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NodeId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link.Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceBuilder
implements Builder<Source> {
    private NodeId _sourceNode;
    private Object _sourceTp;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(Source base) {
        Map aug;
        this._sourceNode = base.getSourceNode();
        this._sourceTp = base.getSourceTp();
        if (base instanceof SourceImpl) {
            SourceImpl impl = (SourceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(aug);
        }
    }

    public NodeId getSourceNode() {
        return this._sourceNode;
    }

    public Object getSourceTp() {
        return this._sourceTp;
    }

    public <E extends Augmentation<Source>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SourceBuilder setSourceNode(NodeId value) {
        this._sourceNode = value;
        return this;
    }

    public SourceBuilder setSourceTp(Object value) {
        this._sourceTp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    implements Source {
        private final NodeId _sourceNode;
        private final Object _sourceTp;
        private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SourceImpl(SourceBuilder base) {
            this._sourceNode = base.getSourceNode();
            this._sourceTp = base.getSourceTp();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Source> getImplementedInterface() {
            return Source.class;
        }

        @Override
        public NodeId getSourceNode() {
            return this._sourceNode;
        }

        @Override
        public Object getSourceTp() {
            return this._sourceTp;
        }

        public <E extends Augmentation<Source>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._sourceNode);
            result = 31 * result + Objects.hashCode(this._sourceTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Source.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Source other = (Source)obj;
            if (!Objects.equals(this._sourceNode, other.getSourceNode())) {
                return false;
            }
            if (!Objects.equals(this._sourceTp, other.getSourceTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceImpl otherImpl = (SourceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Source>>, Augmentation<Source>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Source");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceNode", (Object)this._sourceNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceTp", (Object)this._sourceTp);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

