/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NetworkId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.topology.rev180226.networks.network.link.SupportingLinkKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingLinkBuilder
implements Builder<SupportingLink> {
    private Object _linkRef;
    private NetworkId _networkRef;
    private SupportingLinkKey key;
    Map<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> augmentation = Collections.emptyMap();

    public SupportingLinkBuilder() {
    }

    public SupportingLinkBuilder(SupportingLink base) {
        Map aug;
        this.key = base.key();
        this._linkRef = base.getLinkRef();
        this._networkRef = base.getNetworkRef();
        if (base instanceof SupportingLinkImpl) {
            SupportingLinkImpl impl = (SupportingLinkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>(aug);
        }
    }

    public SupportingLinkKey key() {
        return this.key;
    }

    public Object getLinkRef() {
        return this._linkRef;
    }

    public NetworkId getNetworkRef() {
        return this._networkRef;
    }

    public <E extends Augmentation<SupportingLink>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SupportingLinkBuilder withKey(SupportingLinkKey key) {
        this.key = key;
        return this;
    }

    public SupportingLinkBuilder setLinkRef(Object value) {
        this._linkRef = value;
        return this;
    }

    public SupportingLinkBuilder setNetworkRef(NetworkId value) {
        this._networkRef = value;
        return this;
    }

    public SupportingLinkBuilder addAugmentation(Class<? extends Augmentation<SupportingLink>> augmentationType, Augmentation<SupportingLink> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingLinkBuilder removeAugmentation(Class<? extends Augmentation<SupportingLink>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SupportingLink build() {
        return new SupportingLinkImpl(this);
    }

    private static final class SupportingLinkImpl
    implements SupportingLink {
        private final Object _linkRef;
        private final NetworkId _networkRef;
        private final SupportingLinkKey key;
        private Map<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportingLinkImpl(SupportingLinkBuilder base) {
            this.key = base.key() != null ? base.key() : new SupportingLinkKey(base.getLinkRef(), base.getNetworkRef());
            this._linkRef = this.key.getLinkRef();
            this._networkRef = this.key.getNetworkRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SupportingLink> getImplementedInterface() {
            return SupportingLink.class;
        }

        @Override
        public SupportingLinkKey key() {
            return this.key;
        }

        @Override
        public Object getLinkRef() {
            return this._linkRef;
        }

        @Override
        public NetworkId getNetworkRef() {
            return this._networkRef;
        }

        public <E extends Augmentation<SupportingLink>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._linkRef);
            result = 31 * result + Objects.hashCode(this._networkRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingLink.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingLink other = (SupportingLink)obj;
            if (!Objects.equals(this._linkRef, other.getLinkRef())) {
                return false;
            }
            if (!Objects.equals(this._networkRef, other.getNetworkRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingLinkImpl otherImpl = (SupportingLinkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SupportingLink");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkRef", (Object)this._linkRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkRef", (Object)this._networkRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

