/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.DSFTracker;
import org.apache.aries.jpa.container.impl.DataSourceTracker;
import org.apache.aries.jpa.container.impl.ManagedEMF;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AriesEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AriesEntityManagerFactoryBuilder.class);
    private static final String JPA_CONFIGURATION_PREFIX = "org.apache.aries.jpa.";
    private static final String JAVAX_PERSISTENCE_JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JAVAX_PERSISTENCE_JTA_DATASOURCE = "javax.persistence.jtaDataSource";
    private static final String JAVAX_PERSISTENCE_DATASOURCE = "javax.persistence.dataSource";
    private static final String JAVAX_PERSISTENCE_NON_JTA_DATASOURCE = "javax.persistence.nonJtaDataSource";
    private static final String JAVAX_PERSISTENCE_TX_TYPE = "javax.persistence.transactionType";
    private boolean closed;
    private final PersistenceProvider provider;
    private final Bundle providerBundle;
    private final PersistenceUnit persistenceUnit;
    private final BundleContext containerContext;
    private final PersistenceUnitTransactionType originalTxType;
    private final Bundle bundle;
    private String driver;
    private EntityManagerFactory emf;
    private ServiceRegistration<EntityManagerFactory> reg;
    private ServiceRegistration<?> configReg;
    private Object activeConnectionProvider;
    private Map<String, Object> activeProps;
    private ServiceTracker<?, ?> tracker;
    private boolean complete;

    public AriesEntityManagerFactoryBuilder(BundleContext containerContext, PersistenceProvider provider, Bundle providerBundle, PersistenceUnit persistenceUnit) {
        this.provider = provider;
        this.providerBundle = providerBundle;
        this.persistenceUnit = persistenceUnit;
        this.containerContext = containerContext;
        this.originalTxType = persistenceUnit.getTransactionType();
        this.bundle = persistenceUnit.getBundle();
        this.driver = persistenceUnit.getProperties().getProperty(JAVAX_PERSISTENCE_JDBC_DRIVER);
        this.tracker = this.createDataSourceTracker(provider);
        if (this.tracker != null) {
            this.tracker.open();
        }
        this.registerManagedService(containerContext, persistenceUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTracker<?, ?> createDataSourceTracker(PersistenceProvider provider) {
        if (this.usesDataSource()) {
            AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
            synchronized (ariesEntityManagerFactoryBuilder) {
                this.driver = "Pre Configured DataSource";
            }
            if (!this.usesDataSourceService()) {
                LOGGER.warn("Persistence unit " + this.persistenceUnit.getPersistenceUnitName() + " refers to a non OSGi service DataSource");
                return null;
            }
            DataSourceTracker dsTracker = new DataSourceTracker(this.containerContext, this, DataSourceTracker.getDsName(this.persistenceUnit));
            return dsTracker;
        }
        if (this.usesDSF()) {
            String jdbcClass = DSFTracker.getDriverName(this.persistenceUnit);
            AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
            synchronized (ariesEntityManagerFactoryBuilder) {
                this.driver = jdbcClass;
            }
            DSFTracker dsfTracker = new DSFTracker(this.containerContext, this, jdbcClass);
            return dsfTracker;
        }
        LOGGER.debug("Persistence unit " + this.getPUName() + " does not refer a DataSource. It can only be used with EntityManagerFactoryBuilder.");
        return null;
    }

    private boolean usesDataSource() {
        return this.persistenceUnit.getJtaDataSourceName() != null || this.persistenceUnit.getNonJtaDataSourceName() != null;
    }

    private boolean usesDSF() {
        return DSFTracker.getDriverName(this.persistenceUnit) != null;
    }

    private boolean usesDataSourceService() {
        return this.persistenceUnit.getJtaDataSourceName() != null && this.persistenceUnit.getJtaDataSourceName().startsWith("osgi:service/javax.sql.DataSource") || this.persistenceUnit.getNonJtaDataSourceName() != null && this.persistenceUnit.getNonJtaDataSourceName().startsWith("osgi:service/javax.sql.DataSource");
    }

    @Override
    public String getPersistenceProviderName() {
        String name = this.persistenceUnit.getPersistenceProviderClassName();
        return name == null ? this.provider.getClass().getName() : name;
    }

    @Override
    public Bundle getPersistenceProviderBundle() {
        return this.providerBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory createEntityManagerFactory(Map<String, Object> props) {
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (this.closed) {
                throw new IllegalStateException("The EntityManagerFactoryBuilder for " + this.getPUName() + " is no longer valid");
            }
        }
        if (this.bundle.getState() == 1 || this.bundle.getState() == 2 || this.bundle.getState() == 16) {
            throw new IllegalStateException("The EntityManagerFactoryBuilder for " + this.getPUName() + " is no longer valid");
        }
        Map<String, Object> processedProperties = this.processProperties(props);
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder2 = this;
        synchronized (ariesEntityManagerFactoryBuilder2) {
            if (processedProperties.equals(this.activeProps) && this.emf != null) {
                return this.emf;
            }
        }
        this.closeEMF();
        final EntityManagerFactory toUse = this.createAndPublishEMF(processedProperties);
        return (EntityManagerFactory)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("close".equals(method.getName())) {
                    AriesEntityManagerFactoryBuilder.this.closeEMF();
                    return null;
                }
                return method.invoke((Object)toUse, args);
            }
        });
    }

    public String getPUName() {
        return this.persistenceUnit.getPersistenceUnitName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map<String, Object> processProperties(Map<String, Object> props) {
        HashMap<String, Object> processed = new HashMap<String, Object>();
        Properties punitProps = this.persistenceUnit.getProperties();
        for (String string : punitProps.stringPropertyNames()) {
            processed.put(string, punitProps.get(string));
        }
        if (props != null) {
            processed.putAll(props);
        }
        String newDriver = (String)processed.get(JAVAX_PERSISTENCE_JDBC_DRIVER);
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (newDriver != null) {
                if (this.driver == null) {
                    this.driver = newDriver;
                } else if (!newDriver.equals(this.driver)) {
                    throw new IllegalArgumentException("Cannot rebind to a different database driver, as per the JPA service specification");
                }
            }
        }
        boolean bl = false;
        Object o = processed.get(JAVAX_PERSISTENCE_JTA_DATASOURCE);
        if (o instanceof DataSource) {
            this.persistenceUnit.setJtaDataSource((DataSource)o);
            processed.remove(JAVAX_PERSISTENCE_JTA_DATASOURCE);
            boolean bl2 = true;
        }
        if ((o = processed.get(JAVAX_PERSISTENCE_NON_JTA_DATASOURCE)) instanceof DataSource) {
            this.persistenceUnit.setNonJtaDataSource((DataSource)o);
            processed.remove(JAVAX_PERSISTENCE_NON_JTA_DATASOURCE);
            boolean bl3 = true;
        } else {
            o = processed.get(JAVAX_PERSISTENCE_DATASOURCE);
            if (o != null && o instanceof DataSource) {
                this.persistenceUnit.setNonJtaDataSource((DataSource)o);
                processed.remove(JAVAX_PERSISTENCE_DATASOURCE);
                boolean bl4 = true;
            }
        }
        o = processed.get(JAVAX_PERSISTENCE_TX_TYPE);
        if (o instanceof PersistenceUnitTransactionType) {
            this.persistenceUnit.setTransactionType((PersistenceUnitTransactionType)o);
        } else if (o instanceof String) {
            this.persistenceUnit.setTransactionType(PersistenceUnitTransactionType.valueOf((String)((String)o)));
        } else {
            LOGGER.debug("No transaction type set in config, restoring the original value {}", (Object)this.originalTxType);
            this.persistenceUnit.setTransactionType(this.originalTxType);
        }
        processed.put(PersistenceUnitTransactionType.class.getName(), this.persistenceUnit.getTransactionType());
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder2 = this;
        synchronized (ariesEntityManagerFactoryBuilder2) {
            void var5_11;
            this.complete = var5_11 != false || this.complete && this.tracker != null;
        }
        return processed;
    }

    private void registerManagedService(BundleContext containerContext, PersistenceUnitInfo persistenceUnit) {
        Hashtable<String, String> configuration = new Hashtable<String, String>();
        ((Dictionary)configuration).put("service.pid", JPA_CONFIGURATION_PREFIX + persistenceUnit.getPersistenceUnitName());
        this.configReg = containerContext.registerService(ManagedService.class, (Object)new ManagedEMF(this, persistenceUnit.getPersistenceUnitName()), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEMF() {
        ServiceRegistration<EntityManagerFactory> emfReg;
        EntityManagerFactory emf;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            emf = this.emf;
            this.emf = null;
            emfReg = this.reg;
            this.reg = null;
        }
        if (emfReg != null) {
            try {
                emfReg.unregister();
            }
            catch (Exception e) {
                LOGGER.debug("Exception on unregister", (Throwable)e);
            }
        }
        if (emf != null && emf.isOpen()) {
            try {
                emf.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing EntityManagerFactory for " + this.getPUName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceTracker<?, ?> toClose;
        boolean unregister = false;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            this.closed = true;
            unregister = true;
            toClose = this.tracker;
        }
        if (unregister) {
            try {
                this.configReg.unregister();
            }
            catch (Exception e) {
                LOGGER.debug("Exception on unregister", (Throwable)e);
            }
        }
        if (toClose != null) {
            toClose.close();
        }
        this.closeEMF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createAndPublishEMF(Map<String, Object> overrides) {
        Object dsfTracker;
        String dbDriver;
        boolean makeTracker;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            makeTracker = this.driver != null && this.tracker == null;
            dbDriver = this.driver;
        }
        if (makeTracker) {
            dsfTracker = new DSFTracker(this.containerContext, this, dbDriver);
            AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder2 = this;
            synchronized (ariesEntityManagerFactoryBuilder2) {
                this.tracker = dsfTracker;
                this.activeProps = overrides;
            }
            dsfTracker.open();
            ariesEntityManagerFactoryBuilder2 = this;
            synchronized (ariesEntityManagerFactoryBuilder2) {
                if (this.emf == null) {
                    throw new IllegalStateException("No database driver is currently available for class " + dbDriver);
                }
                return this.emf;
            }
        }
        dsfTracker = this;
        synchronized (dsfTracker) {
            if (!this.complete) {
                throw new IllegalArgumentException("The persistence unit " + this.getPUName() + " has incomplete configuration and cannot be created. The configuration is" + overrides);
            }
        }
        final EntityManagerFactory tmp = this.provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnit, overrides);
        boolean register = false;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder3 = this;
        synchronized (ariesEntityManagerFactoryBuilder3) {
            if (this.emf == null) {
                this.emf = tmp;
                this.activeProps = overrides;
                register = true;
            }
        }
        if (register) {
            Dictionary<String, Object> props = this.createBuilderProperties(overrides);
            BundleContext uctx = this.bundle.getBundleContext();
            ServiceRegistration tmpReg = uctx.registerService(EntityManagerFactory.class, (Object)((EntityManagerFactory)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("close".equals(method.getName())) {
                        return null;
                    }
                    return method.invoke((Object)tmp, args);
                }
            })), props);
            AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder4 = this;
            synchronized (ariesEntityManagerFactoryBuilder4) {
                if (this.emf == tmp) {
                    this.reg = tmpReg;
                } else {
                    register = false;
                }
            }
            if (!register) {
                tmpReg.unregister();
            }
        } else {
            tmp.close();
            ariesEntityManagerFactoryBuilder3 = this;
            synchronized (ariesEntityManagerFactoryBuilder3) {
                return this.emf;
            }
        }
        return tmp;
    }

    private Dictionary<String, Object> createBuilderProperties(Map<String, Object> config) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> e : config.entrySet()) {
            String key = e.getKey();
            if ("javax.persistence.jdbc.password".equals(key)) continue;
            Object value = e.getValue();
            if (key == null || value == null) continue;
            ((Dictionary)props).put(key, e.getValue());
        }
        if (this.persistenceUnit.getPersistenceProviderClassName() != null) {
            ((Dictionary)props).put("osgi.unit.provider", this.persistenceUnit.getPersistenceProviderClassName());
        }
        ((Dictionary)props).put("osgi.unit.version", this.bundle.getVersion().toString());
        ((Dictionary)props).put("osgi.unit.name", this.persistenceUnit.getPersistenceUnitName());
        return props;
    }

    public static Dictionary<String, String> createBuilderProperties(PersistenceUnitInfo persistenceUnit, Bundle puBundle) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", persistenceUnit.getPersistenceUnitName());
        if (persistenceUnit.getPersistenceProviderClassName() != null) {
            ((Dictionary)props).put("osgi.unit.provider", persistenceUnit.getPersistenceProviderClassName());
        }
        ((Dictionary)props).put("osgi.unit.version", puBundle.getVersion().toString());
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foundDSF(DataSourceFactory dsf) {
        boolean build = false;
        HashMap<String, Object> props = null;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (this.activeConnectionProvider == null) {
                this.activeConnectionProvider = dsf;
                build = true;
                props = this.activeProps == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.activeProps);
            }
        }
        if (build) {
            Properties punitProps = this.persistenceUnit.getProperties();
            for (String key : punitProps.stringPropertyNames()) {
                if (props.containsKey(key)) continue;
                props.put(key, punitProps.get(key));
            }
            DataSource ds = DSFTracker.createDataSource(dsf, props, this.persistenceUnit.getName());
            this.dataSourceReady(ds, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostDSF(DataSourceFactory dsf, DataSourceFactory replacement) {
        boolean destroy = false;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (this.activeConnectionProvider == dsf) {
                this.activeConnectionProvider = null;
                destroy = true;
            }
        }
        if (destroy) {
            this.closeEMF();
        }
        if (replacement != null) {
            this.foundDSF(replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foundDS(DataSource ds) {
        boolean build = false;
        HashMap props = null;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (this.activeConnectionProvider == null) {
                this.activeConnectionProvider = ds;
                build = true;
                props = this.activeProps == null ? new HashMap() : new HashMap<String, Object>(this.activeProps);
            }
        }
        if (build) {
            this.dataSourceReady(ds, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostDS(DataSource ds, DataSource replacement) {
        boolean destroy = false;
        AriesEntityManagerFactoryBuilder ariesEntityManagerFactoryBuilder = this;
        synchronized (ariesEntityManagerFactoryBuilder) {
            if (this.activeConnectionProvider == ds) {
                this.activeConnectionProvider = null;
                destroy = true;
            }
        }
        if (destroy) {
            this.closeEMF();
        }
        if (replacement != null) {
            this.foundDS(replacement);
        }
    }

    private void dataSourceReady(DataSource ds, Map<String, Object> props) {
        if (this.persistenceUnit.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            props.put(JAVAX_PERSISTENCE_JTA_DATASOURCE, ds);
        } else {
            props.put(JAVAX_PERSISTENCE_NON_JTA_DATASOURCE, ds);
        }
        this.createEntityManagerFactory(props);
    }
}

