/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.AriesEntityManagerFactoryBuilder;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFTracker
extends ServiceTracker<DataSourceFactory, DataSourceFactory> {
    static final String JDBC_DRIVER = "javax.persistence.jdbc.driver";
    static final String JDBC_URL = "javax.persistence.jdbc.url";
    static final String JDBC_USER = "javax.persistence.jdbc.user";
    static final String JDBC_PASSWORD = "javax.persistence.jdbc.password";
    private static final Logger LOGGER = LoggerFactory.getLogger(DSFTracker.class);
    private final AriesEntityManagerFactoryBuilder builder;
    private final String driverClass;

    public DSFTracker(BundleContext context, AriesEntityManagerFactoryBuilder builder, String driverClass) {
        super(context, DSFTracker.createFilter(context, driverClass, builder.getPUName()), null);
        this.builder = builder;
        this.driverClass = driverClass;
    }

    static Filter createFilter(BundleContext context, String driverClass, String puName) {
        if (driverClass == null) {
            throw new IllegalArgumentException("No javax.persistence.jdbc.driver supplied in persistence.xml");
        }
        String filter = String.format("(&(objectClass=%s)(%s=%s))", DataSourceFactory.class.getName(), "osgi.jdbc.driver.class", driverClass);
        LOGGER.info("Tracking DataSourceFactory for punit " + puName + " with filter " + filter);
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getDriverName(PersistenceUnit punit) {
        return punit.getProperties().getProperty(JDBC_DRIVER);
    }

    public DataSourceFactory addingService(ServiceReference<DataSourceFactory> reference) {
        LOGGER.info("Found DataSourceFactory for " + this.builder.getPUName() + " of type " + this.driverClass);
        try {
            DataSourceFactory dsf = (DataSourceFactory)super.addingService(reference);
            if (dsf != null) {
                this.builder.foundDSF(dsf);
            }
            return dsf;
        }
        catch (Exception e) {
            LOGGER.error("Error creating DataSource for punit " + this.builder.getPUName(), (Throwable)e);
            return null;
        }
    }

    static DataSource createDataSource(DataSourceFactory dsf, Map<String, Object> punitProps, String punitName) {
        try {
            Properties props = new Properties();
            DSFTracker.put(props, "url", punitProps, JDBC_URL);
            DSFTracker.put(props, "user", punitProps, JDBC_USER);
            DSFTracker.put(props, "password", punitProps, JDBC_PASSWORD);
            return dsf.createDataSource(props);
        }
        catch (SQLException e) {
            String msg = "Error creating DataSource for persistence unit " + punitName + ". " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    private static void put(Properties props, String destKey, Map<String, Object> punitProps, String sourceKey) {
        Object value = punitProps.get(sourceKey);
        if (value != null) {
            props.setProperty(destKey, String.valueOf(value));
        }
    }

    public void removedService(ServiceReference<DataSourceFactory> reference, DataSourceFactory dsf) {
        LOGGER.info("Lost DataSourceFactory for " + this.builder.getPUName() + " of type " + this.driverClass);
        this.builder.lostDSF(dsf, (DataSourceFactory)this.getService());
        super.removedService(reference, (Object)dsf);
    }
}

