/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.jpa.container.impl.PersistenceProviderTracker;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnitParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBundleTracker
implements BundleTrackerCustomizer<Bundle> {
    private static final String OSGI_EXTENDER_NS = "osgi.extender";
    private static final String OSGI_CONTRACT_NS = "osgi.contract";
    private static final String JAVA_JPA_CONTRACT = "JavaJPA";
    private static final String OSGI_PACKAGE_NS = "osgi.wiring.package";
    private static final String JAVAX_PERSISTENCE_PKG = "javax.persistence";
    private static final String JPA_SERVICE_PKG = "org.osgi.service.jpa";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceBundleTracker.class);
    private final Map<Bundle, Collection<PersistenceProviderTracker>> trackers;
    private final Map<Integer, String> typeMap;
    private final BundleWiring wiring;

    public PersistenceBundleTracker(BundleWiring bundleWiring) {
        this.wiring = bundleWiring;
        this.trackers = new HashMap<Bundle, Collection<PersistenceProviderTracker>>();
        this.typeMap = new HashMap<Integer, String>();
        this.typeMap.put(1, "INSTALLED");
        this.typeMap.put(512, "LAZY_ACTIVATION");
        this.typeMap.put(32, "RESOLVED");
        this.typeMap.put(2, "STARTED");
        this.typeMap.put(128, "Starting");
        this.typeMap.put(4, "STOPPED");
        this.typeMap.put(16, "UNINSTALLED");
        this.typeMap.put(256, "UNRESOLVED");
        this.typeMap.put(8, "UPDATED");
    }

    public synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
        if (this.incompatibleExtender(bundle)) {
            LOGGER.info("The bundle {} is wired to a different JPA Extender and must be ignored.", (Object)bundle.getSymbolicName());
            return null;
        }
        if (this.incompatibleClassSpace(bundle)) {
            LOGGER.warn("The bundle {} does not share a class space with the JPA Extender and must be ignored.", (Object)bundle.getSymbolicName());
            return null;
        }
        if (event != null && event.getType() == 4) {
            return bundle;
        }
        if (this.getTrackers(bundle).isEmpty()) {
            this.findPersistenceUnits(bundle, event);
        }
        return bundle;
    }

    private boolean incompatibleExtender(Bundle bundle) {
        List requiredWires = ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires(OSGI_EXTENDER_NS);
        for (BundleWire bw : requiredWires) {
            BundleCapability capability = bw.getCapability();
            if (!"osgi.jpa".equals(capability.getAttributes().get(OSGI_EXTENDER_NS))) continue;
            return !capability.getRevision().equals(this.wiring.getRevision());
        }
        return false;
    }

    private boolean incompatibleClassSpace(Bundle bundle) {
        BundleWiring pbWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        BundleCapability pbContract = this.getUsedCapability(pbWiring, OSGI_CONTRACT_NS, JAVA_JPA_CONTRACT);
        if (pbContract != null) {
            LOGGER.debug("Matching JPA contract for possible persistence bundle {}", (Object)bundle.getSymbolicName());
            BundleCapability implContract = this.getUsedCapability(pbWiring, OSGI_CONTRACT_NS, JAVA_JPA_CONTRACT);
            return !pbContract.equals(implContract);
        }
        BundleCapability pbJavaxPersistence = this.getUsedCapability(pbWiring, OSGI_PACKAGE_NS, JAVAX_PERSISTENCE_PKG);
        if (pbJavaxPersistence != null) {
            LOGGER.debug("Matching JPA API package for possible persistence bundle {}", (Object)bundle.getSymbolicName());
            BundleCapability implJavaxPersistence = this.getUsedCapability(pbWiring, OSGI_PACKAGE_NS, JAVAX_PERSISTENCE_PKG);
            return !pbJavaxPersistence.equals(implJavaxPersistence);
        }
        BundleCapability pbJpaService = this.getUsedCapability(pbWiring, OSGI_PACKAGE_NS, JPA_SERVICE_PKG);
        if (pbJpaService != null) {
            LOGGER.debug("Matching JPA service package for possible persistence bundle {}", (Object)bundle.getSymbolicName());
            BundleCapability implJpaService = this.getUsedCapability(pbWiring, OSGI_PACKAGE_NS, JPA_SERVICE_PKG);
            return !pbJpaService.equals(implJpaService);
        }
        return false;
    }

    private BundleCapability getUsedCapability(BundleWiring toCheck, String ns, String attr) {
        BundleCapability cap = null;
        for (BundleWire bw : toCheck.getRequiredWires(ns)) {
            BundleCapability capability = bw.getCapability();
            if (!attr.equals(capability.getAttributes().get(ns))) continue;
            cap = capability;
            break;
        }
        if (cap == null) {
            for (BundleCapability capability : toCheck.getCapabilities(ns)) {
                if (!attr.equals(capability.getAttributes().get(ns))) continue;
                cap = capability;
                break;
            }
        }
        return cap;
    }

    public synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        Collection<PersistenceProviderTracker> providerTrackers = this.trackers.remove(bundle);
        if (providerTrackers == null || providerTrackers.isEmpty()) {
            return;
        }
        LOGGER.info("removing persistence units for " + bundle.getSymbolicName() + " " + this.getType(event));
        for (PersistenceProviderTracker providerTracker : providerTrackers) {
            providerTracker.close();
        }
        providerTrackers.clear();
    }

    private void findPersistenceUnits(Bundle bundle, BundleEvent event) {
        for (PersistenceUnit punit : PersistenceUnitParser.getPersistenceUnits(bundle)) {
            punit.addAnnotated();
            this.trackProvider(bundle, punit);
        }
        if (!this.getTrackers(bundle).isEmpty()) {
            LOGGER.info("Persistence units added for bundle " + bundle.getSymbolicName() + " event " + PersistenceBundleTracker.getEventType(event));
        }
    }

    private static Integer getEventType(BundleEvent event) {
        return event != null ? Integer.valueOf(event.getType()) : null;
    }

    private void trackProvider(Bundle bundle, PersistenceUnit punit) {
        LOGGER.info(String.format("Found persistence unit %s in bundle %s with provider %s.", punit.getPersistenceUnitName(), bundle.getSymbolicName(), punit.getPersistenceProviderClassName()));
        PersistenceProviderTracker tracker = new PersistenceProviderTracker(bundle.getBundleContext(), punit);
        tracker.open();
        this.getTrackers(bundle).add(tracker);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
    }

    private String getType(BundleEvent event) {
        if (event == null) {
            return "null";
        }
        int type = event.getType();
        String typeSt = this.typeMap.get(type);
        return typeSt != null ? typeSt : "unknown event type: " + type;
    }

    private Collection<PersistenceProviderTracker> getTrackers(Bundle bundle) {
        Collection<PersistenceProviderTracker> providerTrackers = this.trackers.get(bundle);
        if (providerTrackers == null) {
            providerTrackers = new ArrayList<PersistenceProviderTracker>();
            this.trackers.put(bundle, providerTrackers);
        }
        return providerTrackers;
    }
}

