/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.Dictionary;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.AriesEntityManagerFactoryBuilder;
import org.apache.aries.jpa.container.impl.StoredPerProvider;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.apache.aries.jpa.container.weaving.impl.DummyDataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceProviderTracker
extends ServiceTracker<PersistenceProvider, StoredPerProvider> {
    private static final String JAVAX_PERSISTENCE_PROVIDER = "javax.persistence.provider";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceProviderTracker.class);
    private PersistenceUnit punit;

    public PersistenceProviderTracker(BundleContext containerContext, PersistenceUnit punit) {
        super(containerContext, PersistenceProviderTracker.createFilter(containerContext, punit), null);
        this.punit = punit;
    }

    private static Filter createFilter(BundleContext context, PersistenceUnit punit) {
        String filter = punit.getPersistenceProviderClassName() != null ? String.format("(&(objectClass=%s)(%s=%s))", PersistenceProvider.class.getName(), JAVAX_PERSISTENCE_PROVIDER, punit.getPersistenceProviderClassName()) : String.format("(objectClass=%s)", PersistenceProvider.class.getName());
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public StoredPerProvider addingService(ServiceReference<PersistenceProvider> reference) {
        String providerName = (String)reference.getProperty(JAVAX_PERSISTENCE_PROVIDER);
        if (this.punit.getPersistenceProviderClassName() == null) {
            this.punit.setProviderClassName(providerName);
        }
        StoredPerProvider stored = new StoredPerProvider();
        LOGGER.info("Found provider for " + this.punit.getPersistenceUnitName() + " " + this.punit.getPersistenceProviderClassName());
        PersistenceProvider provider = (PersistenceProvider)this.context.getService(reference);
        this.createAndCloseDummyEMF(provider);
        stored.builder = new AriesEntityManagerFactoryBuilder(this.context, provider, reference.getBundle(), this.punit);
        Dictionary<String, String> props = AriesEntityManagerFactoryBuilder.createBuilderProperties(this.punit, this.punit.getBundle());
        stored.reg = this.context.registerService(EntityManagerFactoryBuilder.class, (Object)stored.builder, props);
        return stored;
    }

    private void createAndCloseDummyEMF(PersistenceProvider provider) {
        DummyDataSource dummyDataSource = new DummyDataSource();
        this.punit.setJtaDataSource(dummyDataSource);
        this.punit.setNonJtaDataSource(dummyDataSource);
        try {
            EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.punit, null);
            emf.close();
        }
        catch (Exception e) {
            LOGGER.debug("Error while creating the Dummy EntityManagerFactory to allow weaving.", (Throwable)e);
        }
        this.punit.setJtaDataSource(null);
        this.punit.setNonJtaDataSource(null);
    }

    public void removedService(ServiceReference<PersistenceProvider> reference, StoredPerProvider stored) {
        LOGGER.info("Lost provider for " + this.punit.getPersistenceUnitName() + " " + this.punit.getPersistenceProviderClassName());
        try {
            stored.reg.unregister();
        }
        catch (Exception e) {
            LOGGER.debug("An exception occurred unregistering a persistence unit {}", (Object)stored.builder.getPUName());
        }
        if (stored.builder != null) {
            stored.builder.close();
        }
        super.removedService(reference, (Object)stored);
    }
}

