/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parser.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.aries.jpa.container.parser.impl.TempBundleDelegatingClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JPAAnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(JPAAnnotationScanner.class);

    private JPAAnnotationScanner() {
    }

    public static Collection<String> findJPAAnnotatedClasses(Bundle b) {
        BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
        Collection resources = bw.listResources("/", "*.class", 3);
        ArrayList<String> classes = new ArrayList<String>();
        TempBundleDelegatingClassLoader cl = new TempBundleDelegatingClassLoader(b, JPAAnnotationScanner.class.getClassLoader());
        for (String s : resources) {
            s = s.replace('/', '.').substring(0, s.length() - 6);
            try {
                Class<?> clazz = Class.forName(s, false, cl);
                if (!clazz.isAnnotationPresent(Entity.class) && !clazz.isAnnotationPresent(MappedSuperclass.class) && !clazz.isAnnotationPresent(Embeddable.class)) continue;
                classes.add(s);
            }
            catch (ClassNotFoundException e) {
                JPAAnnotationScanner.logEx(e);
            }
            catch (NoClassDefFoundError e) {
                JPAAnnotationScanner.logEx(e);
            }
        }
        return classes;
    }

    private static void logEx(Throwable e) {
        LOG.debug("Exception while scanning for JPA annotations", e);
    }
}

