/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.aries.jpa.container.parser.impl.JPAHandler;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceUnitParser {
    private static final String DEFAULT_PERSISTENCE_LOCATION = "META-INF/persistence.xml";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    public static final String PERSISTENCE_UNIT_HEADER = "Meta-Persistence";

    private PersistenceUnitParser() {
    }

    public static Collection<PersistenceUnit> getPersistenceUnits(Bundle bundle) {
        ArrayList<PersistenceUnit> punits = new ArrayList<PersistenceUnit>();
        Dictionary headers = bundle.getHeaders();
        String metaPersistence = (String)headers.get(PERSISTENCE_UNIT_HEADER);
        HashSet<String> locations = new HashSet<String>();
        if (metaPersistence == null) {
            return punits;
        }
        if (!metaPersistence.isEmpty()) {
            for (String s : metaPersistence.split(",")) {
                locations.add(s.trim());
            }
        }
        if (!locations.contains(DEFAULT_PERSISTENCE_LOCATION)) {
            locations.add(DEFAULT_PERSISTENCE_LOCATION);
        }
        for (String location : locations) {
            try {
                InputStream is = PersistenceUnitParser.locateFile(bundle, location);
                if (is == null) continue;
                PersistenceUnitParser.parse(bundle, is, punits);
            }
            catch (Exception e) {
                LOG.error("exception.while.locating.descriptor", (Throwable)e);
                return Collections.emptySet();
            }
        }
        return punits;
    }

    private static void parse(Bundle bundle, InputStream is, Collection<PersistenceUnit> punits) {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = parserFactory.newSAXParser();
            JPAHandler handler = new JPAHandler(bundle);
            parser.parse(is, (DefaultHandler)handler);
            punits.addAll(handler.getPersistenceUnits());
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing persistence unit in bundle " + bundle.getSymbolicName(), e);
        }
        finally {
            PersistenceUnitParser.safeClose(is);
        }
    }

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.debug("Exception while closing", (Throwable)e);
            }
        }
    }

    private static InputStream locateFile(Bundle bundle, String location) throws IOException {
        if ("".equals(location)) {
            return null;
        }
        int bangIndex = location.indexOf(33);
        if (bangIndex == -1) {
            URL url = bundle.getEntry(location);
            if (url != null) {
                return url.openStream();
            }
        } else {
            URL url = bundle.getEntry(location.substring(0, bangIndex));
            if (url != null) {
                String toLocate = location.substring(bangIndex + 2);
                return PersistenceUnitParser.locateInJar(url, toLocate);
            }
        }
        return null;
    }

    private static InputStream locateInJar(URL url, String toLocate) throws IOException {
        JarInputStream jis = new JarInputStream(url.openStream());
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().equals(toLocate)) {
                return jis;
            }
            entry = jis.getNextJarEntry();
        }
        return null;
    }
}

