/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PayloadBuilder
implements Builder<Payload> {
    private Integer _id;
    private PayloadKey key;
    Map<Class<? extends Augmentation<Payload>>, Augmentation<Payload>> augmentation = Collections.emptyMap();

    public PayloadBuilder() {
    }

    public PayloadBuilder(Payload base) {
        Map aug;
        this.key = base.key();
        this._id = base.getId();
        if (base instanceof PayloadImpl) {
            PayloadImpl impl = (PayloadImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Payload>>, Augmentation<Payload>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Payload>>, Augmentation<Payload>>(aug);
        }
    }

    public PayloadKey key() {
        return this.key;
    }

    public Integer getId() {
        return this._id;
    }

    public <E$$ extends Augmentation<Payload>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PayloadBuilder withKey(PayloadKey key) {
        this.key = key;
        return this;
    }

    public PayloadBuilder setId(Integer value) {
        this._id = value;
        return this;
    }

    public PayloadBuilder addAugmentation(Class<? extends Augmentation<Payload>> augmentationType, Augmentation<Payload> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Payload>>, Augmentation<Payload>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PayloadBuilder removeAugmentation(Class<? extends Augmentation<Payload>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Payload build() {
        return new PayloadImpl(this);
    }

    private static final class PayloadImpl
    implements Payload {
        private final Integer _id;
        private final PayloadKey key;
        private Map<Class<? extends Augmentation<Payload>>, Augmentation<Payload>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PayloadImpl(PayloadBuilder base) {
            this.key = base.key() != null ? base.key() : new PayloadKey(base.getId());
            this._id = this.key.getId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Payload> getImplementedInterface() {
            return Payload.class;
        }

        @Override
        public PayloadKey key() {
            return this.key;
        }

        @Override
        public Integer getId() {
            return this._id;
        }

        public <E$$ extends Augmentation<Payload>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Payload.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Payload other = (Payload)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PayloadImpl otherImpl = (PayloadImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Payload>>, Augmentation<Payload>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Payload");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

