/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartTestInputBuilder
implements Builder<StartTestInput> {
    private Long _iterations;
    private Long _listeners;
    private Long _payloadSize;
    private StartTestInput.ProducerType _producerType;
    private Long _producers;
    Map<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> augmentation = Collections.emptyMap();

    public StartTestInputBuilder() {
    }

    public StartTestInputBuilder(StartTestInput base) {
        Map aug;
        this._iterations = base.getIterations();
        this._listeners = base.getListeners();
        this._payloadSize = base.getPayloadSize();
        this._producerType = base.getProducerType();
        this._producers = base.getProducers();
        if (base instanceof StartTestInputImpl) {
            StartTestInputImpl impl = (StartTestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>(aug);
        }
    }

    public Long getIterations() {
        return this._iterations;
    }

    public Long getListeners() {
        return this._listeners;
    }

    public Long getPayloadSize() {
        return this._payloadSize;
    }

    public StartTestInput.ProducerType getProducerType() {
        return this._producerType;
    }

    public Long getProducers() {
        return this._producers;
    }

    public <E$$ extends Augmentation<StartTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkIterationsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setIterations(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkIterationsRange(value);
        }
        this._iterations = value;
        return this;
    }

    private static void checkListenersRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setListeners(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkListenersRange(value);
        }
        this._listeners = value;
        return this;
    }

    private static void checkPayloadSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setPayloadSize(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkPayloadSizeRange(value);
        }
        this._payloadSize = value;
        return this;
    }

    public StartTestInputBuilder setProducerType(StartTestInput.ProducerType value) {
        this._producerType = value;
        return this;
    }

    private static void checkProducersRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setProducers(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkProducersRange(value);
        }
        this._producers = value;
        return this;
    }

    public StartTestInputBuilder addAugmentation(Class<? extends Augmentation<StartTestInput>> augmentationType, Augmentation<StartTestInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartTestInputBuilder removeAugmentation(Class<? extends Augmentation<StartTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestInput build() {
        return new StartTestInputImpl(this);
    }

    private static final class StartTestInputImpl
    implements StartTestInput {
        private final Long _iterations;
        private final Long _listeners;
        private final Long _payloadSize;
        private final StartTestInput.ProducerType _producerType;
        private final Long _producers;
        private Map<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartTestInputImpl(StartTestInputBuilder base) {
            this._iterations = base.getIterations();
            this._listeners = base.getListeners();
            this._payloadSize = base.getPayloadSize();
            this._producerType = base.getProducerType();
            this._producers = base.getProducers();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartTestInput> getImplementedInterface() {
            return StartTestInput.class;
        }

        @Override
        public Long getIterations() {
            return this._iterations;
        }

        @Override
        public Long getListeners() {
            return this._listeners;
        }

        @Override
        public Long getPayloadSize() {
            return this._payloadSize;
        }

        @Override
        public StartTestInput.ProducerType getProducerType() {
            return this._producerType;
        }

        @Override
        public Long getProducers() {
            return this._producers;
        }

        public <E$$ extends Augmentation<StartTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._iterations);
            result = 31 * result + Objects.hashCode(this._listeners);
            result = 31 * result + Objects.hashCode(this._payloadSize);
            result = 31 * result + Objects.hashCode((Object)this._producerType);
            result = 31 * result + Objects.hashCode(this._producers);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartTestInput other = (StartTestInput)obj;
            if (!Objects.equals(this._iterations, other.getIterations())) {
                return false;
            }
            if (!Objects.equals(this._listeners, other.getListeners())) {
                return false;
            }
            if (!Objects.equals(this._payloadSize, other.getPayloadSize())) {
                return false;
            }
            if (!Objects.equals((Object)this._producerType, (Object)other.getProducerType())) {
                return false;
            }
            if (!Objects.equals(this._producers, other.getProducers())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartTestInputImpl otherImpl = (StartTestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iterations", (Object)this._iterations);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_listeners", (Object)this._listeners);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_payloadSize", (Object)this._payloadSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producerType", (Object)((Object)this._producerType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_producers", (Object)this._producers);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

