/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartTestInputBuilder
implements Builder<StartTestInput> {
    private Long _iterations;
    private Long _numClients;
    private Long _numServers;
    private StartTestInput.Operation _operation;
    private Long _payloadSize;
    Map<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> augmentation = Collections.emptyMap();

    public StartTestInputBuilder() {
    }

    public StartTestInputBuilder(StartTestInput base) {
        Map aug;
        this._iterations = base.getIterations();
        this._numClients = base.getNumClients();
        this._numServers = base.getNumServers();
        this._operation = base.getOperation();
        this._payloadSize = base.getPayloadSize();
        if (base instanceof StartTestInputImpl) {
            StartTestInputImpl impl = (StartTestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>(aug);
        }
    }

    public Long getIterations() {
        return this._iterations;
    }

    public Long getNumClients() {
        return this._numClients;
    }

    public Long getNumServers() {
        return this._numServers;
    }

    public StartTestInput.Operation getOperation() {
        return this._operation;
    }

    public Long getPayloadSize() {
        return this._payloadSize;
    }

    public <E$$ extends Augmentation<StartTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkIterationsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setIterations(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkIterationsRange(value);
        }
        this._iterations = value;
        return this;
    }

    private static void checkNumClientsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setNumClients(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkNumClientsRange(value);
        }
        this._numClients = value;
        return this;
    }

    private static void checkNumServersRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setNumServers(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkNumServersRange(value);
        }
        this._numServers = value;
        return this;
    }

    public StartTestInputBuilder setOperation(StartTestInput.Operation value) {
        this._operation = value;
        return this;
    }

    private static void checkPayloadSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartTestInputBuilder setPayloadSize(Long value) {
        if (value != null) {
            StartTestInputBuilder.checkPayloadSizeRange(value);
        }
        this._payloadSize = value;
        return this;
    }

    public StartTestInputBuilder addAugmentation(Class<? extends Augmentation<StartTestInput>> augmentationType, Augmentation<StartTestInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartTestInputBuilder removeAugmentation(Class<? extends Augmentation<StartTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestInput build() {
        return new StartTestInputImpl(this);
    }

    private static final class StartTestInputImpl
    implements StartTestInput {
        private final Long _iterations;
        private final Long _numClients;
        private final Long _numServers;
        private final StartTestInput.Operation _operation;
        private final Long _payloadSize;
        private Map<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartTestInputImpl(StartTestInputBuilder base) {
            this._iterations = base.getIterations();
            this._numClients = base.getNumClients();
            this._numServers = base.getNumServers();
            this._operation = base.getOperation();
            this._payloadSize = base.getPayloadSize();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartTestInput> getImplementedInterface() {
            return StartTestInput.class;
        }

        @Override
        public Long getIterations() {
            return this._iterations;
        }

        @Override
        public Long getNumClients() {
            return this._numClients;
        }

        @Override
        public Long getNumServers() {
            return this._numServers;
        }

        @Override
        public StartTestInput.Operation getOperation() {
            return this._operation;
        }

        @Override
        public Long getPayloadSize() {
            return this._payloadSize;
        }

        public <E$$ extends Augmentation<StartTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._iterations);
            result = 31 * result + Objects.hashCode(this._numClients);
            result = 31 * result + Objects.hashCode(this._numServers);
            result = 31 * result + Objects.hashCode((Object)this._operation);
            result = 31 * result + Objects.hashCode(this._payloadSize);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartTestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartTestInput other = (StartTestInput)obj;
            if (!Objects.equals(this._iterations, other.getIterations())) {
                return false;
            }
            if (!Objects.equals(this._numClients, other.getNumClients())) {
                return false;
            }
            if (!Objects.equals(this._numServers, other.getNumServers())) {
                return false;
            }
            if (!Objects.equals((Object)this._operation, (Object)other.getOperation())) {
                return false;
            }
            if (!Objects.equals(this._payloadSize, other.getPayloadSize())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartTestInputImpl otherImpl = (StartTestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartTestInput>>, Augmentation<StartTestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartTestInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iterations", (Object)this._iterations);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_numClients", (Object)this._numClients);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_numServers", (Object)this._numServers);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operation", (Object)((Object)this._operation));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_payloadSize", (Object)this._payloadSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

