/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TestStatusOutputBuilder
implements Builder<TestStatusOutput> {
    private TestStatusOutput.ExecStatus _execStatus;
    private Long _globalServerCnt;
    Map<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>> augmentation = Collections.emptyMap();

    public TestStatusOutputBuilder() {
    }

    public TestStatusOutputBuilder(TestStatusOutput base) {
        Map aug;
        this._execStatus = base.getExecStatus();
        this._globalServerCnt = base.getGlobalServerCnt();
        if (base instanceof TestStatusOutputImpl) {
            TestStatusOutputImpl impl = (TestStatusOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>>(aug);
        }
    }

    public TestStatusOutput.ExecStatus getExecStatus() {
        return this._execStatus;
    }

    public Long getGlobalServerCnt() {
        return this._globalServerCnt;
    }

    public <E$$ extends Augmentation<TestStatusOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TestStatusOutputBuilder setExecStatus(TestStatusOutput.ExecStatus value) {
        this._execStatus = value;
        return this;
    }

    private static void checkGlobalServerCntRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public TestStatusOutputBuilder setGlobalServerCnt(Long value) {
        if (value != null) {
            TestStatusOutputBuilder.checkGlobalServerCntRange(value);
        }
        this._globalServerCnt = value;
        return this;
    }

    public TestStatusOutputBuilder addAugmentation(Class<? extends Augmentation<TestStatusOutput>> augmentationType, Augmentation<TestStatusOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TestStatusOutputBuilder removeAugmentation(Class<? extends Augmentation<TestStatusOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TestStatusOutput build() {
        return new TestStatusOutputImpl(this);
    }

    private static final class TestStatusOutputImpl
    implements TestStatusOutput {
        private final TestStatusOutput.ExecStatus _execStatus;
        private final Long _globalServerCnt;
        private Map<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TestStatusOutputImpl(TestStatusOutputBuilder base) {
            this._execStatus = base.getExecStatus();
            this._globalServerCnt = base.getGlobalServerCnt();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TestStatusOutput> getImplementedInterface() {
            return TestStatusOutput.class;
        }

        @Override
        public TestStatusOutput.ExecStatus getExecStatus() {
            return this._execStatus;
        }

        @Override
        public Long getGlobalServerCnt() {
            return this._globalServerCnt;
        }

        public <E$$ extends Augmentation<TestStatusOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._execStatus);
            result = 31 * result + Objects.hashCode(this._globalServerCnt);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TestStatusOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TestStatusOutput other = (TestStatusOutput)obj;
            if (!Objects.equals((Object)this._execStatus, (Object)other.getExecStatus())) {
                return false;
            }
            if (!Objects.equals(this._globalServerCnt, other.getGlobalServerCnt())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TestStatusOutputImpl otherImpl = (TestStatusOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TestStatusOutput>>, Augmentation<TestStatusOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TestStatusOutput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_execStatus", (Object)((Object)this._execStatus));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalServerCnt", (Object)this._globalServerCnt);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

