/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.algorithms.scoring.util.DelegateToEdgeTransformer;
import edu.uci.ics.jung.algorithms.scoring.util.VEPair;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractIterativeScorer<V, E, T>
implements IterativeContext,
VertexScorer<V, T> {
    protected int max_iterations;
    protected double tolerance;
    protected Hypergraph<V, E> graph;
    protected int total_iterations;
    protected Function<VEPair<V, E>, ? extends Number> edge_weights;
    protected boolean output_reversed;
    private Map<V, T> output;
    private Map<V, T> current_values;
    private boolean accept_disconnected_graph;
    protected boolean hyperedges_are_self_loops = false;
    protected double max_delta;

    protected void setOutputValue(V v, T value) {
        this.output.put(v, value);
    }

    protected T getOutputValue(V v) {
        return this.output.get(v);
    }

    protected T getCurrentValue(V v) {
        return this.current_values.get(v);
    }

    protected void setCurrentValue(V v, T value) {
        this.current_values.put(v, value);
    }

    public AbstractIterativeScorer(Hypergraph<V, E> g, Function<? super E, ? extends Number> edge_weights) {
        this.graph = g;
        this.max_iterations = 100;
        this.tolerance = 0.001;
        this.accept_disconnected_graph = true;
        this.setEdgeWeights(edge_weights);
    }

    public AbstractIterativeScorer(Hypergraph<V, E> g) {
        this.graph = g;
        this.max_iterations = 100;
        this.tolerance = 0.001;
        this.accept_disconnected_graph = true;
    }

    protected void initialize() {
        this.total_iterations = 0;
        this.max_delta = Double.MIN_VALUE;
        this.output_reversed = true;
        this.current_values = new HashMap<V, T>();
        this.output = new HashMap<V, T>();
    }

    public void evaluate() {
        do {
            this.step();
        } while (!this.done());
    }

    @Override
    public boolean done() {
        return this.total_iterations >= this.max_iterations || this.max_delta < this.tolerance;
    }

    @Override
    public void step() {
        this.swapOutputForCurrent();
        for (Object v : this.graph.getVertices()) {
            double diff = this.update(v);
            this.updateMaxDelta(v, diff);
        }
        ++this.total_iterations;
        this.afterStep();
    }

    protected void swapOutputForCurrent() {
        Map<T, T> tmp = this.output;
        this.output = this.current_values;
        this.current_values = tmp;
        this.output_reversed = !this.output_reversed;
    }

    protected abstract double update(V var1);

    protected void updateMaxDelta(V v, double diff) {
        this.max_delta = Math.max(this.max_delta, diff);
    }

    protected void afterStep() {
    }

    @Override
    public T getVertexScore(V v) {
        if (!this.graph.containsVertex(v)) {
            throw new IllegalArgumentException("Vertex " + v + " not an element of this graph");
        }
        return this.output.get(v);
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public int getIterations() {
        return this.total_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        this.max_iterations = max_iterations;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public Function<VEPair<V, E>, ? extends Number> getEdgeWeights() {
        return this.edge_weights;
    }

    public void setEdgeWeights(Function<? super E, ? extends Number> edge_weights) {
        this.edge_weights = new DelegateToEdgeTransformer<V, E>(edge_weights);
    }

    protected Number getEdgeWeight(V v, E e) {
        return (Number)this.edge_weights.apply(new VEPair<V, E>(v, e));
    }

    protected void collectDisappearingPotential(V v) {
    }

    public void acceptDisconnectedGraph(boolean accept) {
        this.accept_disconnected_graph = accept;
    }

    public boolean isDisconnectedGraphOK() {
        return this.accept_disconnected_graph;
    }

    public void setHyperedgesAreSelfLoops(boolean arg) {
        this.hyperedges_are_self_loops = arg;
    }

    protected int getAdjustedIncidentCount(E e) {
        return this.graph.getIncidentCount(e) - (this.hyperedges_are_self_loops ? 0 : 1);
    }
}

