/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4.address.subnet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4.address.subnet.PrefixLength;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PrefixLengthBuilder
implements Builder<PrefixLength> {
    private Short _prefixLength;
    Map<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>> augmentation = Collections.emptyMap();

    public PrefixLengthBuilder() {
    }

    public PrefixLengthBuilder(PrefixLength base) {
        Map aug;
        this._prefixLength = base.getPrefixLength();
        if (base instanceof PrefixLengthImpl) {
            PrefixLengthImpl impl = (PrefixLengthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>>(aug);
        }
    }

    public Short getPrefixLength() {
        return this._prefixLength;
    }

    public <E$$ extends Augmentation<PrefixLength>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkPrefixLengthRange(short value) {
        if (value >= 0 && value <= 32) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..32]]", (int)value);
    }

    public PrefixLengthBuilder setPrefixLength(Short value) {
        if (value != null) {
            PrefixLengthBuilder.checkPrefixLengthRange(value);
        }
        this._prefixLength = value;
        return this;
    }

    public PrefixLengthBuilder addAugmentation(Class<? extends Augmentation<PrefixLength>> augmentationType, Augmentation<PrefixLength> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PrefixLengthBuilder removeAugmentation(Class<? extends Augmentation<PrefixLength>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PrefixLength build() {
        return new PrefixLengthImpl(this);
    }

    private static final class PrefixLengthImpl
    implements PrefixLength {
        private final Short _prefixLength;
        private Map<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PrefixLengthImpl(PrefixLengthBuilder base) {
            this._prefixLength = base.getPrefixLength();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PrefixLength> getImplementedInterface() {
            return PrefixLength.class;
        }

        @Override
        public Short getPrefixLength() {
            return this._prefixLength;
        }

        public <E$$ extends Augmentation<PrefixLength>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._prefixLength);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PrefixLength.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PrefixLength other = (PrefixLength)obj;
            if (!Objects.equals(this._prefixLength, other.getPrefixLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PrefixLengthImpl otherImpl = (PrefixLengthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PrefixLength>>, Augmentation<PrefixLength>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PrefixLength");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefixLength", (Object)this._prefixLength);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

