/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.AddressKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddressBuilder
implements Builder<Address> {
    private Ipv6AddressNoZone _ip;
    private Short _prefixLength;
    private AddressKey key;
    Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();

    public AddressBuilder() {
    }

    public AddressBuilder(Address base) {
        Map aug;
        this.key = base.key();
        this._ip = base.getIp();
        this._prefixLength = base.getPrefixLength();
        if (base instanceof AddressImpl) {
            AddressImpl impl = (AddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(aug);
        }
    }

    public AddressKey key() {
        return this.key;
    }

    public Ipv6AddressNoZone getIp() {
        return this._ip;
    }

    public Short getPrefixLength() {
        return this._prefixLength;
    }

    public <E$$ extends Augmentation<Address>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AddressBuilder withKey(AddressKey key) {
        this.key = key;
        return this;
    }

    public AddressBuilder setIp(Ipv6AddressNoZone value) {
        this._ip = value;
        return this;
    }

    private static void checkPrefixLengthRange(short value) {
        if (value >= 0 && value <= 128) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..128]]", (int)value);
    }

    public AddressBuilder setPrefixLength(Short value) {
        if (value != null) {
            AddressBuilder.checkPrefixLengthRange(value);
        }
        this._prefixLength = value;
        return this;
    }

    public AddressBuilder addAugmentation(Class<? extends Augmentation<Address>> augmentationType, Augmentation<Address> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AddressBuilder removeAugmentation(Class<? extends Augmentation<Address>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Address build() {
        return new AddressImpl(this);
    }

    private static final class AddressImpl
    implements Address {
        private final Ipv6AddressNoZone _ip;
        private final Short _prefixLength;
        private final AddressKey key;
        private Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AddressImpl(AddressBuilder base) {
            this.key = base.key() != null ? base.key() : new AddressKey(base.getIp());
            this._ip = this.key.getIp();
            this._prefixLength = base.getPrefixLength();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Address> getImplementedInterface() {
            return Address.class;
        }

        @Override
        public AddressKey key() {
            return this.key;
        }

        @Override
        public Ipv6AddressNoZone getIp() {
            return this._ip;
        }

        @Override
        public Short getPrefixLength() {
            return this._prefixLength;
        }

        public <E$$ extends Augmentation<Address>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._prefixLength);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Address.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Address other = (Address)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._prefixLength, other.getPrefixLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddressImpl otherImpl = (AddressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Address>>, Augmentation<Address>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Address");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ip", (Object)this._ip);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefixLength", (Object)this._prefixLength);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

