/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Autoconf;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AutoconfBuilder
implements Builder<Autoconf> {
    private Long _temporaryPreferredLifetime;
    private Long _temporaryValidLifetime;
    private Boolean _createGlobalAddresses;
    private Boolean _createTemporaryAddresses;
    Map<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>> augmentation = Collections.emptyMap();

    public AutoconfBuilder() {
    }

    public AutoconfBuilder(Autoconf base) {
        Map aug;
        this._temporaryPreferredLifetime = base.getTemporaryPreferredLifetime();
        this._temporaryValidLifetime = base.getTemporaryValidLifetime();
        this._createGlobalAddresses = base.isCreateGlobalAddresses();
        this._createTemporaryAddresses = base.isCreateTemporaryAddresses();
        if (base instanceof AutoconfImpl) {
            AutoconfImpl impl = (AutoconfImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>>(aug);
        }
    }

    public Long getTemporaryPreferredLifetime() {
        return this._temporaryPreferredLifetime;
    }

    public Long getTemporaryValidLifetime() {
        return this._temporaryValidLifetime;
    }

    public Boolean isCreateGlobalAddresses() {
        return this._createGlobalAddresses;
    }

    public Boolean isCreateTemporaryAddresses() {
        return this._createTemporaryAddresses;
    }

    public <E$$ extends Augmentation<Autoconf>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkTemporaryPreferredLifetimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public AutoconfBuilder setTemporaryPreferredLifetime(Long value) {
        if (value != null) {
            AutoconfBuilder.checkTemporaryPreferredLifetimeRange(value);
        }
        this._temporaryPreferredLifetime = value;
        return this;
    }

    private static void checkTemporaryValidLifetimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public AutoconfBuilder setTemporaryValidLifetime(Long value) {
        if (value != null) {
            AutoconfBuilder.checkTemporaryValidLifetimeRange(value);
        }
        this._temporaryValidLifetime = value;
        return this;
    }

    public AutoconfBuilder setCreateGlobalAddresses(Boolean value) {
        this._createGlobalAddresses = value;
        return this;
    }

    public AutoconfBuilder setCreateTemporaryAddresses(Boolean value) {
        this._createTemporaryAddresses = value;
        return this;
    }

    public AutoconfBuilder addAugmentation(Class<? extends Augmentation<Autoconf>> augmentationType, Augmentation<Autoconf> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AutoconfBuilder removeAugmentation(Class<? extends Augmentation<Autoconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Autoconf build() {
        return new AutoconfImpl(this);
    }

    private static final class AutoconfImpl
    implements Autoconf {
        private final Long _temporaryPreferredLifetime;
        private final Long _temporaryValidLifetime;
        private final Boolean _createGlobalAddresses;
        private final Boolean _createTemporaryAddresses;
        private Map<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AutoconfImpl(AutoconfBuilder base) {
            this._temporaryPreferredLifetime = base.getTemporaryPreferredLifetime();
            this._temporaryValidLifetime = base.getTemporaryValidLifetime();
            this._createGlobalAddresses = base.isCreateGlobalAddresses();
            this._createTemporaryAddresses = base.isCreateTemporaryAddresses();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Autoconf> getImplementedInterface() {
            return Autoconf.class;
        }

        @Override
        public Long getTemporaryPreferredLifetime() {
            return this._temporaryPreferredLifetime;
        }

        @Override
        public Long getTemporaryValidLifetime() {
            return this._temporaryValidLifetime;
        }

        @Override
        public Boolean isCreateGlobalAddresses() {
            return this._createGlobalAddresses;
        }

        @Override
        public Boolean isCreateTemporaryAddresses() {
            return this._createTemporaryAddresses;
        }

        public <E$$ extends Augmentation<Autoconf>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._temporaryPreferredLifetime);
            result = 31 * result + Objects.hashCode(this._temporaryValidLifetime);
            result = 31 * result + Objects.hashCode(this._createGlobalAddresses);
            result = 31 * result + Objects.hashCode(this._createTemporaryAddresses);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Autoconf.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Autoconf other = (Autoconf)obj;
            if (!Objects.equals(this._temporaryPreferredLifetime, other.getTemporaryPreferredLifetime())) {
                return false;
            }
            if (!Objects.equals(this._temporaryValidLifetime, other.getTemporaryValidLifetime())) {
                return false;
            }
            if (!Objects.equals(this._createGlobalAddresses, other.isCreateGlobalAddresses())) {
                return false;
            }
            if (!Objects.equals(this._createTemporaryAddresses, other.isCreateTemporaryAddresses())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AutoconfImpl otherImpl = (AutoconfImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Autoconf>>, Augmentation<Autoconf>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Autoconf");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_temporaryPreferredLifetime", (Object)this._temporaryPreferredLifetime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_temporaryValidLifetime", (Object)this._temporaryValidLifetime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_createGlobalAddresses", (Object)this._createGlobalAddresses);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_createTemporaryAddresses", (Object)this._createTemporaryAddresses);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

