/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.IpAddressOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.Ipv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.AddressKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Address
extends ChildOf<Ipv6>,
Augmentable<Address>,
Identifiable<AddressKey> {
    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("address");

    public @Nullable Ipv6AddressNoZone getIp();

    public @Nullable Short getPrefixLength();

    public @Nullable IpAddressOrigin getOrigin();

    public @Nullable Status getStatus();

    public AddressKey key();

    public static enum Status implements Enumeration
    {
        Preferred(0, "preferred"),
        Deprecated(1, "deprecated"),
        Invalid(2, "invalid"),
        Inaccessible(3, "inaccessible"),
        Unknown(4, "unknown"),
        Tentative(5, "tentative"),
        Duplicate(6, "duplicate"),
        Optimistic(7, "optimistic");

        private static final Map<String, Status> NAME_MAP;
        private static final Map<Integer, Status> VALUE_MAP;
        private final String name;
        private final int value;

        private Status(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<Status> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static Status forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (Status enumItem : Status.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

