/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.messaginghub.pooled.jms.JmsPoolSession;

public class JmsPoolMessageProducer
implements MessageProducer,
AutoCloseable {
    private final JmsPoolSession session;
    private final MessageProducer messageProducer;
    private final Destination destination;
    private final AtomicInteger refCount;
    private final boolean anonymousProducer;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private int deliveryMode;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;
    private long deliveryDelay;

    public JmsPoolMessageProducer(JmsPoolSession session, MessageProducer messageProducer, Destination destination, AtomicInteger refCount) throws JMSException {
        this.session = session;
        this.messageProducer = messageProducer;
        this.destination = destination;
        this.refCount = refCount;
        this.anonymousProducer = destination == null;
        this.deliveryMode = messageProducer.getDeliveryMode();
        this.disableMessageID = messageProducer.getDisableMessageID();
        this.disableMessageTimestamp = messageProducer.getDisableMessageTimestamp();
        this.priority = messageProducer.getPriority();
        this.timeToLive = messageProducer.getTimeToLive();
        if (session.isJMSVersionSupported(2, 0)) {
            this.deliveryDelay = messageProducer.getDeliveryDelay();
        }
    }

    @Override
    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.session.onMessageProducerClosed(this);
        }
    }

    public void send(Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        this.sendMessage(this.destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestinationNotInvalid(destination);
        if (!this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Message message, CompletionListener listener) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive, listener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        this.checkClosed();
        if (this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        if (listener == null) {
            throw new IllegalArgumentException("JmsCompletetionListener cannot be null");
        }
        this.sendMessage(this.destination, message, deliveryMode, priority, timeToLive, listener);
    }

    public void send(Destination destination, Message message, CompletionListener listener) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive, listener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        this.checkClosed();
        this.checkDestinationNotInvalid(destination);
        if (!this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("JmsCompletetionListener cannot be null");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        MessageProducer messageProducer;
        MessageProducer messageProducer2 = messageProducer = this.getMessageProducer();
        synchronized (messageProducer2) {
            long oldDelayValue = 0L;
            if (this.deliveryDelay != 0L && this.session.isJMSVersionSupported(2, 0)) {
                oldDelayValue = messageProducer.getDeliveryDelay();
                messageProducer.setDeliveryDelay(this.deliveryDelay);
            }
            try {
                if (this.getDelegate().getDestination() != null) {
                    if (listener == null) {
                        messageProducer.send(message, deliveryMode, priority, timeToLive);
                    } else {
                        messageProducer.send(message, deliveryMode, priority, timeToLive, listener);
                    }
                } else if (listener == null) {
                    messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
                } else {
                    messageProducer.send(destination, message, deliveryMode, priority, timeToLive, listener);
                }
            }
            finally {
                if (this.deliveryDelay != 0L && this.session.isJMSVersionSupported(2, 0)) {
                    messageProducer.setDeliveryDelay(oldDelayValue);
                }
            }
        }
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.deliveryMode = deliveryMode;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkClosed();
        this.disableMessageID = disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public void setPriority(int priority) throws JMSException {
        this.checkClosed();
        this.priority = priority;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    public long getDeliveryDelay() throws JMSException {
        this.checkClosed();
        this.session.checkClientJMSVersionSupport(2, 0);
        return this.deliveryDelay;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.checkClosed();
        this.session.checkClientJMSVersionSupport(2, 0);
        this.deliveryDelay = deliveryDelay;
        this.messageProducer.setDeliveryDelay(deliveryDelay);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.messageProducer + " }";
    }

    public MessageProducer getMessageProducer() throws JMSException {
        this.checkClosed();
        return this.messageProducer;
    }

    public boolean isAnonymousProducer() {
        return this.anonymousProducer;
    }

    public AtomicInteger getRefCount() {
        return this.refCount;
    }

    public MessageProducer getDelegate() {
        return this.messageProducer;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("This message producer has been closed.");
        }
    }

    private void checkDestinationNotInvalid(Destination destination) throws InvalidDestinationException {
        if (destination == null) {
            throw new InvalidDestinationException("Destination must not be null");
        }
    }
}

