/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jdbc.impl.ConnectionHandle;
import org.ops4j.pax.transx.jdbc.impl.XADataSourceMCF;

public class ManagedXAConnection
extends AbstractManagedConnection<XADataSourceMCF, ManagedXAConnection, Connection, ConnectionHandle<XADataSourceMCF, ManagedXAConnection>> {
    private final AbstractManagedConnection.LocalTransactionImpl localTx;
    private final AbstractManagedConnection.LocalTransactionImpl localClientTx;
    private final Connection connection;
    private final XAConnection xaConnection;

    public ManagedXAConnection(XADataSourceMCF mcf, XAConnection xaConnection, XAResource xaResource, Connection connection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) {
        super(mcf, credentialExtractor, exceptionSorter);
        this.connection = connection;
        this.xaConnection = xaConnection;
        this.xaResource = xaResource;
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                SQLException e = event.getSQLException();
                ManagedXAConnection.this.unfilteredConnectionError(e);
            }
        });
        this.localTx = new AbstractManagedConnection.LocalTransactionImpl(true);
        this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl(false);
    }

    @Override
    public Connection getPhysicalConnection() {
        return this.connection;
    }

    @Override
    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    @Override
    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    @Override
    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to disable autoCommit", (Throwable)e);
        }
        super.localTransactionStart(isSPI);
    }

    @Override
    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        try {
            if (((XADataSourceMCF)this.mcf).isCommitBeforeAutocommit()) {
                this.connection.commit();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            block5: {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e1) {
                    if (this.log == null) break block5;
                    e.printStackTrace(this.log);
                }
            }
            throw new LocalTransactionException("Unable to commit", (Throwable)e);
        }
        super.localTransactionCommit(isSPI);
    }

    @Override
    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to rollback", (Throwable)e);
        }
        super.localTransactionRollback(isSPI);
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", (Throwable)e);
        }
    }

    @Override
    protected boolean isValid() {
        try {
            if (this.connection.isValid(0)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void cleanup() throws ResourceException {
        super.cleanup();
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ResourceException("Could not reset autocommit when returning to pool", (Throwable)e);
        }
    }

    @Override
    protected void closePhysicalConnection() throws ResourceException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", (Throwable)e);
        }
    }
}

