/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.NoExceptionsAreFatalSorter;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jdbc.impl.AbstractJdbcManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.ManagedXAConnection;

public class XADataSourceMCF
extends AbstractJdbcManagedConnectionFactory<XADataSourceMCF, ManagedXAConnection, XADataSource> {
    public XADataSourceMCF(XADataSource xaDataSource) {
        this(xaDataSource, (ExceptionSorter)new NoExceptionsAreFatalSorter());
    }

    protected XADataSourceMCF(XADataSource xaDataSource, ExceptionSorter exceptionSorter) {
        super(xaDataSource, exceptionSorter);
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return TransactionSupport.TransactionSupportLevel.XATransaction;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        XAConnection sqlConnection = this.getPhysicalConnection(credentialExtractor);
        try {
            XAResource xares = sqlConnection.getXAResource();
            Connection pc = this.wrap(sqlConnection.getConnection());
            return new ManagedXAConnection(this, sqlConnection, xares, pc, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
        }
    }

    protected XAConnection getPhysicalConnection(CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            String username = credentialExtractor.getUserName();
            String password = credentialExtractor.getPassword();
            if (username != null) {
                return ((XADataSource)this.dataSource).getXAConnection(username, password);
            }
            return ((XADataSource)this.dataSource).getXAConnection();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.dataSource, (Throwable)e);
        }
    }
}

