/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Address;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.japi.Procedure;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.messaging.MessageAssembler;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.base.messages.ApplySnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.ElectionTimeout;
import org.opendaylight.controller.cluster.raft.base.messages.TimeoutNow;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractRaftActorBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.SnapshotTracker;
import org.opendaylight.controller.cluster.raft.behaviors.SyncStatusTracker;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshot;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshotReply;
import org.opendaylight.controller.cluster.raft.messages.RaftRPC;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public class Follower
extends AbstractRaftActorBehavior {
    private static final long MAX_ELECTION_TIMEOUT_FACTOR = 18L;
    private final SyncStatusTracker initialSyncStatusTracker;
    private final MessageAssembler appendEntriesMessageAssembler;
    private final Stopwatch lastLeaderMessageTimer = Stopwatch.createStarted();
    private SnapshotTracker snapshotTracker = null;
    private String leaderId;
    private short leaderPayloadVersion;

    public Follower(RaftActorContext context) {
        this(context, null, -1);
    }

    public Follower(RaftActorContext context, String initialLeaderId, short initialLeaderPayloadVersion) {
        super(context, RaftState.Follower);
        this.leaderId = initialLeaderId;
        this.leaderPayloadVersion = initialLeaderPayloadVersion;
        this.initialSyncStatusTracker = new SyncStatusTracker(context.getActor(), this.getId(), context.getConfigParams().getSyncIndexThreshold());
        this.appendEntriesMessageAssembler = MessageAssembler.builder().logContext(this.logName()).fileBackedStreamFactory(context.getFileBackedOutputStreamFactory()).assembledMessageCallback((message, sender) -> this.handleMessage((ActorRef)sender, message)).build();
        if (context.getPeerIds().isEmpty() && this.getLeaderId() == null) {
            this.actor().tell((Object)TimeoutNow.INSTANCE, this.actor());
        } else {
            this.scheduleElection(this.electionDuration());
        }
    }

    @Override
    public final String getLeaderId() {
        return this.leaderId;
    }

    @VisibleForTesting
    protected final void setLeaderId(@Nullable String leaderId) {
        this.leaderId = leaderId;
    }

    @Override
    public short getLeaderPayloadVersion() {
        return this.leaderPayloadVersion;
    }

    @VisibleForTesting
    protected final void setLeaderPayloadVersion(short leaderPayloadVersion) {
        this.leaderPayloadVersion = leaderPayloadVersion;
    }

    private void restartLastLeaderMessageTimer() {
        if (this.lastLeaderMessageTimer.isRunning()) {
            this.lastLeaderMessageTimer.reset();
        }
        this.lastLeaderMessageTimer.start();
    }

    private boolean isLogEntryPresent(long index) {
        if (this.context.getReplicatedLog().isInSnapshot(index)) {
            return true;
        }
        ReplicatedLogEntry entry = this.context.getReplicatedLog().get(index);
        return entry != null;
    }

    private void updateInitialSyncStatus(long currentLeaderCommit, String newLeaderId) {
        this.initialSyncStatusTracker.update(newLeaderId, currentLeaderCommit, this.context.getCommitIndex());
    }

    @Override
    protected RaftActorBehavior handleAppendEntries(ActorRef sender, AppendEntries appendEntries) {
        int numLogEntries = appendEntries.getEntries().size();
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}: handleAppendEntries: {}", (Object)this.logName(), (Object)appendEntries);
        } else if (this.log.isDebugEnabled() && numLogEntries > 0) {
            this.log.debug("{}: handleAppendEntries: {}", (Object)this.logName(), (Object)appendEntries);
        }
        if (this.snapshotTracker != null && !this.snapshotTracker.getLeaderId().equals(appendEntries.getLeaderId())) {
            this.log.debug("{}: snapshot install is in progress but the prior snapshot leaderId {} does not match the AppendEntries leaderId {}", new Object[]{this.logName(), this.snapshotTracker.getLeaderId(), appendEntries.getLeaderId()});
            this.closeSnapshotTracker();
        }
        if (this.snapshotTracker != null || this.context.getSnapshotManager().isApplying()) {
            AppendEntriesReply reply = new AppendEntriesReply(this.context.getId(), this.currentTerm(), true, this.lastIndex(), this.lastTerm(), this.context.getPayloadVersion(), false, this.needsLeaderAddress(), appendEntries.getLeaderRaftVersion());
            this.log.debug("{}: snapshot install is in progress, replying immediately with {}", (Object)this.logName(), (Object)reply);
            sender.tell((Object)reply, this.actor());
            return this;
        }
        this.leaderId = appendEntries.getLeaderId();
        this.leaderPayloadVersion = appendEntries.getPayloadVersion();
        if (appendEntries.getLeaderAddress().isPresent()) {
            String address = appendEntries.getLeaderAddress().get();
            this.log.debug("New leader address: {}", (Object)address);
            this.context.setPeerAddress(this.leaderId, address);
            this.context.getConfigParams().getPeerAddressResolver().setResolved(this.leaderId, address);
        }
        if (this.isOutOfSync(appendEntries, sender)) {
            this.updateInitialSyncStatus(appendEntries.getLeaderCommit(), appendEntries.getLeaderId());
            return this;
        }
        if (!this.processNewEntries(appendEntries, sender)) {
            this.updateInitialSyncStatus(appendEntries.getLeaderCommit(), appendEntries.getLeaderId());
            return this;
        }
        long lastIndex = this.lastIndex();
        long prevCommitIndex = this.context.getCommitIndex();
        if (appendEntries.getLeaderCommit() > prevCommitIndex) {
            this.context.setCommitIndex(Math.min(appendEntries.getLeaderCommit(), lastIndex));
        }
        if (prevCommitIndex != this.context.getCommitIndex()) {
            this.log.debug("{}: Commit index set to {}", (Object)this.logName(), (Object)this.context.getCommitIndex());
        }
        AppendEntriesReply reply = new AppendEntriesReply(this.context.getId(), this.currentTerm(), true, lastIndex, this.lastTerm(), this.context.getPayloadVersion(), false, this.needsLeaderAddress(), appendEntries.getLeaderRaftVersion());
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}: handleAppendEntries returning : {}", (Object)this.logName(), (Object)reply);
        } else if (this.log.isDebugEnabled() && numLogEntries > 0) {
            this.log.debug("{}: handleAppendEntries returning : {}", (Object)this.logName(), (Object)reply);
        }
        sender.tell((Object)reply, this.actor());
        this.updateInitialSyncStatus(appendEntries.getLeaderCommit(), appendEntries.getLeaderId());
        if (appendEntries.getLeaderCommit() > this.context.getLastApplied() && this.context.getLastApplied() < lastIndex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{}: applyLogToStateMachine, appendEntries.getLeaderCommit(): {}, context.getLastApplied(): {}, lastIndex(): {}", new Object[]{this.logName(), appendEntries.getLeaderCommit(), this.context.getLastApplied(), lastIndex});
            }
            this.applyLogToStateMachine(appendEntries.getLeaderCommit());
        }
        if (!this.context.getSnapshotManager().isCapturing()) {
            super.performSnapshotWithoutCapture(appendEntries.getReplicatedToAllIndex());
        }
        this.appendEntriesMessageAssembler.checkExpiredAssembledMessageState();
        return this;
    }

    private boolean processNewEntries(AppendEntries appendEntries, ActorRef sender) {
        int numLogEntries = appendEntries.getEntries().size();
        if (numLogEntries == 0) {
            return true;
        }
        this.log.debug("{}: Number of entries to be appended = {}", (Object)this.logName(), (Object)numLogEntries);
        long lastIndex = this.lastIndex();
        int addEntriesFrom = 0;
        if (this.context.getReplicatedLog().size() > 0L) {
            ReplicatedLogEntry matchEntry;
            int i = 0;
            while (i < numLogEntries && this.isLogEntryPresent((matchEntry = appendEntries.getEntries().get(i)).getIndex())) {
                long existingEntryTerm = this.getLogEntryTerm(matchEntry.getIndex());
                this.log.debug("{}: matchEntry {} is present: existingEntryTerm: {}", new Object[]{this.logName(), matchEntry, existingEntryTerm});
                if (existingEntryTerm != -1L && existingEntryTerm != matchEntry.getTerm()) {
                    if (!this.context.getRaftPolicy().applyModificationToStateBeforeConsensus()) {
                        this.log.info("{}: Removing entries from log starting at {}, commitIndex: {}, lastApplied: {}", new Object[]{this.logName(), matchEntry.getIndex(), this.context.getCommitIndex(), this.context.getLastApplied()});
                        if (matchEntry.getIndex() > this.context.getLastApplied() && this.context.getReplicatedLog().removeFromAndPersist(matchEntry.getIndex())) break;
                        this.log.info("{}: Could not remove entries - sending reply to force snapshot", (Object)this.logName());
                        sender.tell((Object)new AppendEntriesReply(this.context.getId(), this.currentTerm(), false, lastIndex, this.lastTerm(), this.context.getPayloadVersion(), true, this.needsLeaderAddress(), appendEntries.getLeaderRaftVersion()), this.actor());
                        return false;
                    }
                    sender.tell((Object)new AppendEntriesReply(this.context.getId(), this.currentTerm(), false, lastIndex, this.lastTerm(), this.context.getPayloadVersion(), true, this.needsLeaderAddress(), appendEntries.getLeaderRaftVersion()), this.actor());
                    return false;
                }
                ++i;
                ++addEntriesFrom;
            }
        }
        lastIndex = this.lastIndex();
        this.log.debug("{}: After cleanup, lastIndex: {}, entries to be added from: {}", new Object[]{this.logName(), lastIndex, addEntriesFrom});
        AtomicBoolean shouldCaptureSnapshot = new AtomicBoolean(false);
        Procedure appendAndPersistCallback = logEntry -> {
            List<ReplicatedLogEntry> entries = appendEntries.getEntries();
            ReplicatedLogEntry lastEntryToAppend = entries.get(entries.size() - 1);
            if (shouldCaptureSnapshot.get() && logEntry == lastEntryToAppend) {
                this.context.getSnapshotManager().capture(this.context.getReplicatedLog().last(), this.getReplicatedToAllIndex());
            }
        };
        for (int i = addEntriesFrom; i < numLogEntries; ++i) {
            ReplicatedLogEntry entry = appendEntries.getEntries().get(i);
            this.log.debug("{}: Append entry to log {}", (Object)this.logName(), (Object)entry.getData());
            this.context.getReplicatedLog().appendAndPersist(entry, (Procedure<ReplicatedLogEntry>)appendAndPersistCallback, false);
            shouldCaptureSnapshot.compareAndSet(false, this.context.getReplicatedLog().shouldCaptureSnapshot(entry.getIndex()));
            if (!(entry.getData() instanceof ServerConfigurationPayload)) continue;
            this.context.updatePeerIds((ServerConfigurationPayload)entry.getData());
        }
        this.log.debug("{}: Log size is now {}", (Object)this.logName(), (Object)this.context.getReplicatedLog().size());
        return true;
    }

    private boolean isOutOfSync(AppendEntries appendEntries, ActorRef sender) {
        long lastIndex = this.lastIndex();
        if (lastIndex == -1L && appendEntries.getPrevLogIndex() != -1L) {
            this.log.info("{}: The followers log is empty and the senders prevLogIndex is {}", (Object)this.logName(), (Object)appendEntries.getPrevLogIndex());
            this.sendOutOfSyncAppendEntriesReply(sender, false, appendEntries.getLeaderRaftVersion());
            return true;
        }
        if (lastIndex > -1L) {
            if (this.isLogEntryPresent(appendEntries.getPrevLogIndex())) {
                long leadersPrevLogTermInFollowersLogOrSnapshot = this.getLogEntryOrSnapshotTerm(appendEntries.getPrevLogIndex());
                if (leadersPrevLogTermInFollowersLogOrSnapshot != appendEntries.getPrevLogTerm()) {
                    this.log.info("{}: The prevLogIndex {} was found in the log but the term {} is not equal to the append entries prevLogTerm {} - lastIndex: {}, snapshotIndex: {}, snapshotTerm: {}", new Object[]{this.logName(), appendEntries.getPrevLogIndex(), leadersPrevLogTermInFollowersLogOrSnapshot, appendEntries.getPrevLogTerm(), lastIndex, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm()});
                    this.sendOutOfSyncAppendEntriesReply(sender, false, appendEntries.getLeaderRaftVersion());
                    return true;
                }
            } else if (appendEntries.getPrevLogIndex() != -1L) {
                this.log.info("{}: The log is not empty but the prevLogIndex {} was not found in it - lastIndex: {}, snapshotIndex: {}, snapshotTerm: {}", new Object[]{this.logName(), appendEntries.getPrevLogIndex(), lastIndex, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm()});
                this.sendOutOfSyncAppendEntriesReply(sender, false, appendEntries.getLeaderRaftVersion());
                return true;
            }
        }
        if (appendEntries.getPrevLogIndex() == -1L && appendEntries.getPrevLogTerm() == -1L && appendEntries.getReplicatedToAllIndex() != -1L) {
            if (!this.isLogEntryPresent(appendEntries.getReplicatedToAllIndex())) {
                this.log.info("{}: Cannot append entries because the replicatedToAllIndex {} does not appear to be in the in-memory journal - lastIndex: {}, snapshotIndex: {}, snapshotTerm: {}", new Object[]{this.logName(), appendEntries.getReplicatedToAllIndex(), lastIndex, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm()});
                this.sendOutOfSyncAppendEntriesReply(sender, false, appendEntries.getLeaderRaftVersion());
                return true;
            }
            List<ReplicatedLogEntry> entries = appendEntries.getEntries();
            if (entries.size() > 0 && !this.isLogEntryPresent(entries.get(0).getIndex() - 1L)) {
                this.log.info("{}: Cannot append entries because the calculated previousIndex {} was not found in the in-memory journal - lastIndex: {}, snapshotIndex: {}, snapshotTerm: {}", new Object[]{this.logName(), entries.get(0).getIndex() - 1L, lastIndex, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm()});
                this.sendOutOfSyncAppendEntriesReply(sender, false, appendEntries.getLeaderRaftVersion());
                return true;
            }
        }
        return false;
    }

    private void sendOutOfSyncAppendEntriesReply(ActorRef sender, boolean forceInstallSnapshot, short leaderRaftVersion) {
        AppendEntriesReply reply = new AppendEntriesReply(this.context.getId(), this.currentTerm(), false, this.lastIndex(), this.lastTerm(), this.context.getPayloadVersion(), forceInstallSnapshot, this.needsLeaderAddress(), leaderRaftVersion);
        this.log.info("{}: Follower is out-of-sync so sending negative reply: {}", (Object)this.logName(), (Object)reply);
        sender.tell((Object)reply, this.actor());
    }

    private boolean needsLeaderAddress() {
        return this.context.getPeerAddress(this.leaderId) == null;
    }

    @Override
    protected RaftActorBehavior handleAppendEntriesReply(ActorRef sender, AppendEntriesReply appendEntriesReply) {
        return this;
    }

    @Override
    protected RaftActorBehavior handleRequestVoteReply(ActorRef sender, RequestVoteReply requestVoteReply) {
        return this;
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        if (message instanceof ElectionTimeout || message instanceof TimeoutNow) {
            return this.handleElectionTimeout(message);
        }
        if (this.appendEntriesMessageAssembler.handleMessage(message, this.actor())) {
            return this;
        }
        if (!(message instanceof RaftRPC)) {
            return null;
        }
        RaftRPC rpc = (RaftRPC)message;
        if (rpc.getTerm() > this.context.getTermInformation().getCurrentTerm()) {
            this.log.info("{}: Term {} in \"{}\" message is greater than follower's term {} - updating term", new Object[]{this.logName(), rpc.getTerm(), rpc, this.context.getTermInformation().getCurrentTerm()});
            this.context.getTermInformation().updateAndPersist(rpc.getTerm(), null);
        }
        if (rpc instanceof InstallSnapshot) {
            this.handleInstallSnapshot(sender, (InstallSnapshot)rpc);
            this.restartLastLeaderMessageTimer();
            this.scheduleElection(this.electionDuration());
            return this;
        }
        if (!(rpc instanceof RequestVote) || this.canGrantVote((RequestVote)rpc)) {
            this.restartLastLeaderMessageTimer();
            this.scheduleElection(this.electionDuration());
        }
        return super.handleMessage(sender, rpc);
    }

    /*
     * Enabled aggressive block sorting
     */
    private RaftActorBehavior handleElectionTimeout(Object message) {
        boolean noLeaderMessageReceived;
        long lastLeaderMessageInterval = this.lastLeaderMessageTimer.elapsed(TimeUnit.MILLISECONDS);
        long electionTimeoutInMillis = this.context.getConfigParams().getElectionTimeOutInterval().toMillis();
        boolean bl = noLeaderMessageReceived = !this.lastLeaderMessageTimer.isRunning() || lastLeaderMessageInterval >= electionTimeoutInMillis;
        if (this.canStartElection()) {
            if (message instanceof TimeoutNow) {
                this.log.debug("{}: Received TimeoutNow - switching to Candidate", (Object)this.logName());
                return this.internalSwitchBehavior(RaftState.Candidate);
            }
            if (!noLeaderMessageReceived) {
                this.log.debug("{}: Received ElectionTimeout but lastLeaderMessageInterval {} < election timeout {}", new Object[]{this.logName(), lastLeaderMessageInterval, this.context.getConfigParams().getElectionTimeOutInterval()});
                this.scheduleElection(this.electionDuration());
                return this;
            }
            long maxElectionTimeout = electionTimeoutInMillis * 18L;
            if (this.isLeaderAvailabilityKnown() && lastLeaderMessageInterval < maxElectionTimeout) {
                this.log.debug("{}: Received ElectionTimeout but leader appears to be available", (Object)this.logName());
                this.scheduleElection(this.electionDuration());
                return this;
            }
            this.log.debug("{}: Received ElectionTimeout - switching to Candidate", (Object)this.logName());
            return this.internalSwitchBehavior(RaftState.Candidate);
        }
        if (!(message instanceof ElectionTimeout)) return this;
        if (noLeaderMessageReceived) {
            this.setLeaderId(null);
        }
        this.scheduleElection(this.electionDuration());
        return this;
    }

    private boolean isLeaderAvailabilityKnown() {
        if (this.leaderId == null) {
            return false;
        }
        Optional<Cluster> cluster = this.context.getCluster();
        if (!cluster.isPresent()) {
            return false;
        }
        ActorSelection leaderActor = this.context.getPeerActorSelection(this.leaderId);
        if (leaderActor == null) {
            return false;
        }
        Address leaderAddress = leaderActor.anchorPath().address();
        ClusterEvent.CurrentClusterState state = cluster.get().state();
        Set unreachable = state.getUnreachable();
        this.log.debug("{}: Checking for leader {} in the cluster unreachable set {}", new Object[]{this.logName(), leaderAddress, unreachable});
        for (Member m : unreachable) {
            if (!leaderAddress.equals((Object)m.address())) continue;
            this.log.info("{}: Leader {} is unreachable", (Object)this.logName(), (Object)leaderAddress);
            return false;
        }
        for (Member m : state.getMembers()) {
            if (!leaderAddress.equals((Object)m.address())) continue;
            if (m.status() == MemberStatus.up() || m.status() == MemberStatus.weaklyUp()) {
                this.log.debug("{}: Leader {} cluster status is {} - leader is available", new Object[]{this.logName(), leaderAddress, m.status()});
                return true;
            }
            this.log.debug("{}: Leader {} cluster status is {} - leader is unavailable", new Object[]{this.logName(), leaderAddress, m.status()});
            return false;
        }
        this.log.debug("{}: Leader {} not found in the cluster member set", (Object)this.logName(), (Object)leaderAddress);
        return false;
    }

    private void handleInstallSnapshot(final ActorRef sender, InstallSnapshot installSnapshot) {
        this.log.debug("{}: handleInstallSnapshot: {}", (Object)this.logName(), (Object)installSnapshot);
        this.leaderId = installSnapshot.getLeaderId();
        if (this.snapshotTracker == null) {
            this.snapshotTracker = new SnapshotTracker(this.log, installSnapshot.getTotalChunks(), installSnapshot.getLeaderId(), this.context);
        }
        this.updateInitialSyncStatus(installSnapshot.getLastIncludedIndex(), installSnapshot.getLeaderId());
        try {
            final InstallSnapshotReply reply = new InstallSnapshotReply(this.currentTerm(), this.context.getId(), installSnapshot.getChunkIndex(), true);
            if (this.snapshotTracker.addChunk(installSnapshot.getChunkIndex(), installSnapshot.getData(), installSnapshot.getLastChunkHashCode())) {
                this.log.info("{}: Snapshot installed from leader: {}", (Object)this.logName(), (Object)installSnapshot.getLeaderId());
                Snapshot snapshot = Snapshot.create(this.context.getSnapshotManager().convertSnapshot(this.snapshotTracker.getSnapshotBytes()), new ArrayList<ReplicatedLogEntry>(), installSnapshot.getLastIncludedIndex(), installSnapshot.getLastIncludedTerm(), installSnapshot.getLastIncludedIndex(), installSnapshot.getLastIncludedTerm(), this.context.getTermInformation().getCurrentTerm(), this.context.getTermInformation().getVotedFor(), (ServerConfigurationPayload)installSnapshot.getServerConfig().orNull());
                ApplySnapshot.Callback applySnapshotCallback = new ApplySnapshot.Callback(){

                    @Override
                    public void onSuccess() {
                        Follower.this.log.debug("{}: handleInstallSnapshot returning: {}", (Object)Follower.this.logName(), (Object)reply);
                        sender.tell((Object)reply, Follower.this.actor());
                    }

                    @Override
                    public void onFailure() {
                        sender.tell((Object)new InstallSnapshotReply(Follower.this.currentTerm(), Follower.this.context.getId(), -1, false), Follower.this.actor());
                    }
                };
                this.actor().tell((Object)new ApplySnapshot(snapshot, applySnapshotCallback), this.actor());
                this.closeSnapshotTracker();
            } else {
                this.log.debug("{}: handleInstallSnapshot returning: {}", (Object)this.logName(), (Object)reply);
                sender.tell((Object)reply, this.actor());
            }
        }
        catch (IOException e) {
            this.log.debug("{}: Exception in InstallSnapshot of follower", (Object)this.logName(), (Object)e);
            sender.tell((Object)new InstallSnapshotReply(this.currentTerm(), this.context.getId(), -1, false), this.actor());
            this.closeSnapshotTracker();
        }
    }

    private void closeSnapshotTracker() {
        if (this.snapshotTracker != null) {
            this.snapshotTracker.close();
            this.snapshotTracker = null;
        }
    }

    @Override
    public void close() {
        this.closeSnapshotTracker();
        this.stopElection();
        this.appendEntriesMessageAssembler.close();
    }

    @VisibleForTesting
    SnapshotTracker getSnapshotTracker() {
        return this.snapshotTracker;
    }
}

