/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.raft.base.messages.FollowerInitialSyncUpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStatusTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SyncStatusTracker.class);
    private static final boolean IN_SYNC = true;
    private static final boolean NOT_IN_SYNC = false;
    private final long syncThreshold;
    private final ActorRef actor;
    private final String id;
    private LeaderInfo syncTarget;
    private boolean syncStatus;

    public SyncStatusTracker(ActorRef actor, String id, long syncThreshold) {
        this.actor = (ActorRef)Preconditions.checkNotNull((Object)actor, (Object)"actor should not be null");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id should not be null");
        Preconditions.checkArgument((syncThreshold >= 0L ? 1 : 0) != 0, (Object)"syncThreshold should be greater than or equal to 0");
        this.syncThreshold = syncThreshold;
    }

    public void update(String leaderId, long leaderCommit, long commitIndex) {
        Preconditions.checkNotNull((Object)leaderId, (Object)"leaderId should not be null");
        if (this.syncTarget == null || !leaderId.equals(this.syncTarget.leaderId)) {
            LOG.debug("{}: Last sync leader does not match current leader {}, need to catch up to {}", new Object[]{this.id, leaderId, leaderCommit});
            this.changeSyncStatus(false, true);
            this.syncTarget = new LeaderInfo(leaderId, leaderCommit);
            return;
        }
        long lag = leaderCommit - commitIndex;
        if (lag > this.syncThreshold) {
            LOG.debug("{}: Lagging {} entries behind leader {}", new Object[]{this.id, lag, leaderId});
            this.changeSyncStatus(false, false);
        } else if (commitIndex >= this.syncTarget.minimumCommitIndex) {
            LOG.debug("{}: Lagging {} entries behind leader {} and reached {} (of expected {})", new Object[]{this.id, lag, leaderId, commitIndex, this.syncTarget.minimumCommitIndex});
            this.changeSyncStatus(true, false);
        }
    }

    private void changeSyncStatus(boolean newSyncStatus, boolean forceStatusChange) {
        if (forceStatusChange || newSyncStatus != this.syncStatus) {
            this.actor.tell((Object)new FollowerInitialSyncUpStatus(newSyncStatus, this.id), ActorRef.noSender());
            this.syncStatus = newSyncStatus;
        } else {
            LOG.trace("{}: No change in sync status of, dampening message", (Object)this.id);
        }
    }

    private static final class LeaderInfo {
        final long minimumCommitIndex;
        final String leaderId;

        LeaderInfo(String leaderId, long minimumCommitIndex) {
            this.leaderId = (String)Preconditions.checkNotNull((Object)leaderId);
            this.minimumCommitIndex = minimumCommitIndex;
        }
    }
}

